<!DOCTYPE html>
<html>
<head>
    <title>Complimentary Ticket - <?php echo e($ticket->event->name); ?></title>
    <style>
        body { 
            font-family: 'Arial', sans-serif;
            margin: 0;
            padding: 0;
        }
        .ticket { 
            border: 2px dashed #4e2a87; 
            padding: 30px; 
            max-width: 600px; 
            margin: 0 auto;
            position: relative;
            background-image: url('https://events.pacesetter.co.ke/assets/img/logo/logo.png');
            background-size: cover;
            background-position: center;
            background-repeat: no-repeat;
            background-blend-mode: overlay;
            background-color: rgba(255, 255, 255, 0.9);
        }
        .watermark {
            position: absolute;
            opacity: 0.08;
            font-size: 80px;
            font-weight: bold;
            color: #4e2a87;
            transform: rotate(-30deg);
            top: 25%;
            left: 5%;
            width: 100%;
            text-align: center;
            z-index: 0;
            text-shadow: 2px 2px 4px rgba(0, 0, 0, 0.3);
        }
        .header { 
            text-align: center; 
            margin-bottom: 25px; 
            border-bottom: 2px solid #4e2a87;
            padding-bottom: 15px;
            position: relative;
            z-index: 1;
        }
        .qr-code { 
            text-align: center; 
            margin: 25px 0; 
            position: relative;
            z-index: 1;
        }
        .details { 
            margin-bottom: 25px; 
            position: relative;
            z-index: 1;
            background-color: rgba(255, 255, 255, 0.7);
            padding: 20px;
            border-radius: 8px;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
        }
        .footer { 
            text-align: center; 
            font-size: 12px; 
            margin-top: 25px;
            border-top: 2px solid #4e2a87;
            padding-top: 15px;
            position: relative;
            z-index: 1;
        }
        .ticket-type {
            background: #4e2a87;
            color: white;
            padding: 8px 15px;
            border-radius: 20px;
            display: inline-block;
            margin: 10px 0;
            font-weight: bold;
            text-transform: uppercase;
            letter-spacing: 1px;
            font-size: 14px;
            box-shadow: 0 2px 5px rgba(0, 0, 0, 0.2);
        }
        h1 {
            color: #4e2a87;
            margin-bottom: 10px;
            font-size: 28px;
        }
        .details p {
            margin: 8px 0;
            font-size: 15px;
        }
        .details strong {
            color: #4e2a87;
            min-width: 100px;
            display: inline-block;
        }
        .event-date {
            font-weight: bold;
            color: #4e2a87;
            font-size: 18px;
            margin: 15px 0;
            text-align: center;
        }
    </style>
</head>
<body>
    <div class="ticket">
        <div class="watermark">COMPLIMENTARY</div>
        
        <div class="header">
            <h1><?php echo e($ticket->event->name); ?></h1>
            <div class="ticket-type">Complimentary Ticket</div>
            <div class="event-date">
                <?php echo e($ticket->event->date->format('l, F j, Y')); ?><br>
                <?php echo e($ticket->event->start_time ?? 'Time: From 8:00 a.m'); ?>

            </div>
        </div>
        
        <div class="details">
            <p><strong>Guest Name:</strong> <?php echo e($ticket->first_name); ?> <?php echo e($ticket->last_name); ?></p>
            <p><strong>Venue:</strong> <?php echo e($ticket->event->venue); ?></p>
            <p><strong>Ticket Reference:</strong> TeenzFest Complimentary</p>
            <p><strong>Issued By:</strong> <?php echo e($ticket->generated_by_name ?? 'Pacesetter Entertainment'); ?></p>
        </div>
        
        <?php if(isset($qrCode)): ?>
        <div class="qr-code">
            <img src="data:image/svg+xml;base64,<?php echo e($qrCode); ?>" alt="QR Code">
            <p style="margin-top: 10px; font-size: 12px;">Scan this QR code at entry</p>
        </div>
        <?php endif; ?>
        
        <div class="footer">
            <p>This complimentary ticket grants one-time entry to the specified event</p>
            <p>Not transferable • Not for resale • No cash value</p>
            <p>For inquiries, contact: Thepacesettertalentshow@gmail.com | +254 726 846 918</p>
        </div>
    </div>
</body>
</html><?php /**PATH D:\wamp64\www\paceerror\PaceEvents\resources\views\complimentary\ticket-pdf.blade.php ENDPATH**/ ?>