<!DOCTYPE html>
<html>
<head>
    <title>Complimentary Ticket - <?php echo e($ticket->event->name); ?></title>
    <style>
        body { font-family: Arial, sans-serif; }
        .ticket { border: 2px dashed #000; padding: 20px; max-width: 600px; margin: 0 auto; }
        .header { text-align: center; margin-bottom: 20px; }
        .qr-code { text-align: center; margin: 20px 0; }
        .details { margin-bottom: 20px; }
        .footer { text-align: center; font-size: 12px; margin-top: 20px; }
    </style>
    
</head>
<body>
    <div class="ticket">
        <div class="header">
            <h1><?php echo e($ticket->event->name); ?></h1>
            <h3>COMPLIMENTARY TICKET</h3>
        </div>
        
        <div class="details">
            <p><strong>Name:</strong> <?php echo e($ticket->first_name); ?> <?php echo e($ticket->last_name); ?></p>
            <p><strong>Event Date:</strong> <?php echo e($ticket->event->date->format('F j, Y')); ?></p>
            <p><strong>Venue:</strong> <?php echo e($ticket->event->venue); ?></p>
            <p><strong>Reference:</strong> <?php echo e($ticket->reference); ?></p>
        </div>
        
        <div class="qr-code">
            <!-- QR code with ticket reference -->
            <img src="data:image/png;base64, <?php echo base64_encode(QrCode::format('png')->size(150)->generate($ticket->reference)); ?>">
        </div>
        
        <div class="footer">
            <p>This complimentary ticket is valid for one entry only.</p>
            <p>Present this ticket at the venue for admission.</p>
        </div>
    </div>
</body>
</html><?php /**PATH D:\wamp64\www\paceerror\PaceEvents\resources\views\tickets\complimentary.blade.php ENDPATH**/ ?>