<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>CSV Transaction Processor - PACE Events</title>
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Font Awesome -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    
    <style>
        body {
            background-color: #f8f9fa;
        }
        .card {
            box-shadow: 0 0.125rem 0.25rem rgba(0, 0, 0, 0.075);
            border: 1px solid rgba(0, 0, 0, 0.125);
        }
        .card-header {
            background-color: #6c757d;
            color: white;
        }
    </style>
</head>
<body>
    <div class="container mt-4">
        <div class="row justify-content-center">
            <div class="col-md-8">
                <div class="card">
                    <div class="card-header">
                        <h4><i class="fas fa-file-csv"></i> CSV Transaction Processor</h4>
                    </div>
                    <div class="card-body">
                        <?php if(session('error')): ?>
                            <div class="alert alert-danger">
                                <i class="fas fa-exclamation-triangle"></i> <?php echo e(session('error')); ?>

                            </div>
                        <?php endif; ?>

                        <div class="alert alert-info">
                            <h5><i class="fas fa-info-circle"></i> Instructions:</h5>
                            <ul>
                                <li>Upload a CSV file containing transaction data</li>
                                <li>The system will match records using the A/C No. column (bill reference number)</li>
                                <li>Missing transactions will be created in the transactions table</li>
                                <li>Matching tickets will be updated with payment status and receipt numbers</li>
                                <li><strong>SMS notifications will be sent to users</strong></li>
                                <li><strong>Existing transactions will be skipped</strong> (users already received SMS)</li>
                            </ul>
                        </div>

                        <form action="<?php echo e(route('csv.process')); ?>" method="POST" enctype="multipart/form-data">
                            <?php echo csrf_field(); ?>
                            
                            <div class="form-group mb-3">
                                <label for="csv_file" class="form-label">Select CSV File</label>
                                <input type="file" class="form-control <?php $__errorArgs = ['csv_file'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                       id="csv_file" name="csv_file" accept=".csv,.txt" required>
                                <?php $__errorArgs = ['csv_file'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <div class="form-group mb-3">
                                <button type="submit" class="btn btn-primary">
                                    <i class="fas fa-upload"></i> Process CSV
                                </button>
                                <a href="<?php echo e(route('tickets.index')); ?>" class="btn btn-secondary">
                                    <i class="fas fa-arrow-left"></i> Back to Tickets
                                </a>
                            </div>
                        </form>

                        <div class="mt-4">
                            <h6><i class="fas fa-file-alt"></i> Expected CSV Format:</h6>
                            <small class="text-muted">
                                The CSV should contain columns: Receipt No., Completion Time, Initiation Time, 
                                Details, Transaction Status, Paid In, Withdrawn, Balance, Balance Confirmed, 
                                Reason Type, Other Party Info, Linked Transaction ID, A/C No., Currency
                            </small>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
<?php /**PATH D:\wamp64\www\paceerror\PaceEvents\resources\views\csv-processor\index.blade.php ENDPATH**/ ?>