<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo e($messageTemplate->name); ?> - Message Template</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <?php echo app('Illuminate\Foundation\Vite')(['resources/css/app.css', 'resources/js/app.js']); ?>
    <style>
        .template-container {
            max-width: 800px;
            margin: 0 auto;
            padding: 20px;
        }
        .btn-primary {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            border: none;
        }
        .btn-primary:hover {
            background: linear-gradient(135deg, #5a6fd8 0%, #6a4190 100%);
        }
        .message-preview {
            background: #f8f9fa;
            border: 1px solid #dee2e6;
            border-radius: 8px;
            padding: 20px;
            font-family: 'Courier New', monospace;
            line-height: 1.5;
        }
        .status-badge {
            font-size: 0.875rem;
        }
        .char-count {
            font-size: 0.875rem;
            color: #6c757d;
        }
    </style>
</head>
<body>
    <div class="template-container">
        <!-- Header -->
        <div class="d-flex justify-content-between align-items-start mb-4">
            <div>
                <h1 class="h3 mb-1">
                    <i class="fas fa-file-alt text-primary"></i> 
                    <?php echo e($messageTemplate->name); ?>

                    <?php if($messageTemplate->is_active): ?>
                        <span class="badge bg-success status-badge ms-2">
                            <i class="fas fa-check-circle"></i> Active
                        </span>
                    <?php else: ?>
                        <span class="badge bg-secondary status-badge ms-2">
                            <i class="fas fa-pause-circle"></i> Inactive
                        </span>
                    <?php endif; ?>
                </h1>
                <?php if($messageTemplate->description): ?>
                    <p class="text-muted mb-0"><?php echo e($messageTemplate->description); ?></p>
                <?php endif; ?>
            </div>
            <div class="btn-group" role="group">
                <a href="<?php echo e(route('message-templates.edit', $messageTemplate)); ?>" class="btn btn-outline-primary">
                    <i class="fas fa-edit"></i> Edit
                </a>
                <button type="button" class="btn btn-outline-danger" data-bs-toggle="modal" data-bs-target="#deleteModal">
                    <i class="fas fa-trash"></i> Delete
                </button>
            </div>
        </div>

        <!-- Success Message -->
        <?php if(session('success')): ?>
            <div class="alert alert-success alert-dismissible fade show" role="alert">
                <i class="fas fa-check-circle"></i> <?php echo e(session('success')); ?>

                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
        <?php endif; ?>

        <!-- Message Preview -->
        <div class="card mb-4">
            <div class="card-header">
                <h5 class="card-title mb-0">
                    <i class="fas fa-eye"></i> Message Preview
                </h5>
            </div>
            <div class="card-body">
                <div class="message-preview">
                    <?php echo e($messageTemplate->content); ?>

                </div>
                <div class="d-flex justify-content-between mt-3">
                    <div class="char-count">
                        <strong>Character Count:</strong> 
                        <span class="<?php echo e(strlen($messageTemplate->content) > 160 ? 'text-danger' : (strlen($messageTemplate->content) > 140 ? 'text-warning' : 'text-success')); ?>">
                            <?php echo e(strlen($messageTemplate->content)); ?>/160
                        </span>
                    </div>
                    <?php if(strlen($messageTemplate->content) > 160): ?>
                        <div class="text-danger small">
                            <i class="fas fa-exclamation-triangle"></i> 
                            This message will be sent as <?php echo e(ceil(strlen($messageTemplate->content) / 160)); ?> SMS parts
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>

        <!-- Template Details -->
        <div class="card mb-4">
            <div class="card-header">
                <h5 class="card-title mb-0">
                    <i class="fas fa-info-circle"></i> Template Details
                </h5>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-6">
                        <div class="mb-3">
                            <label class="form-label text-muted small">Template Name</label>
                            <div class="fw-medium"><?php echo e($messageTemplate->name); ?></div>
                        </div>
                        <div class="mb-3">
                            <label class="form-label text-muted small">Status</label>
                            <div>
                                <?php if($messageTemplate->is_active): ?>
                                    <span class="badge bg-success">
                                        <i class="fas fa-check-circle"></i> Active
                                    </span>
                                <?php else: ?>
                                    <span class="badge bg-secondary">
                                        <i class="fas fa-pause-circle"></i> Inactive
                                    </span>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="mb-3">
                            <label class="form-label text-muted small">Created</label>
                            <div class="fw-medium"><?php echo e($messageTemplate->created_at->format('M d, Y \\a\\t g:i A')); ?></div>
                        </div>
                        <div class="mb-3">
                            <label class="form-label text-muted small">Last Updated</label>
                            <div class="fw-medium"><?php echo e($messageTemplate->updated_at->format('M d, Y \\a\\t g:i A')); ?></div>
                        </div>
                    </div>
                </div>
                <?php if($messageTemplate->description): ?>
                    <div class="mb-0">
                        <label class="form-label text-muted small">Description</label>
                        <div class="fw-medium"><?php echo e($messageTemplate->description); ?></div>
                    </div>
                <?php endif; ?>
            </div>
        </div>

        <!-- Actions -->
        <div class="d-flex justify-content-between">
            <a href="<?php echo e(route('admin.message-templates.index')); ?>" class="btn btn-outline-secondary">
                <i class="fas fa-arrow-left"></i> Back to Templates
            </a>
            <div>
                <a href="<?php echo e(route('admin.message-templates.edit', $messageTemplate)); ?>" class="btn btn-primary me-2">
                    <i class="fas fa-edit"></i> Edit Template
                </a>
                <button type="button" class="btn btn-outline-success" onclick="copyToClipboard()">
                    <i class="fas fa-copy"></i> Copy Content
                </button>
            </div>
        </div>
    </div>

    <!-- Delete Modal -->
    <div class="modal fade" id="deleteModal" tabindex="-1">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">
                        <i class="fas fa-exclamation-triangle text-danger"></i> 
                        Confirm Delete
                    </h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <p>Are you sure you want to delete the template <strong>"<?php echo e($messageTemplate->name); ?>"</strong>?</p>
                    <p class="text-danger small mb-0">
                        <i class="fas fa-warning"></i> 
                        This action cannot be undone.
                    </p>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">
                        Cancel
                    </button>
                    <form action="<?php echo e(route('admin.message-templates.destroy', $messageTemplate)); ?>" method="POST" class="d-inline">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('DELETE'); ?>
                        <button type="submit" class="btn btn-danger">
                            <i class="fas fa-trash"></i> Delete Template
                        </button>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        function copyToClipboard() {
            const content = `<?php echo e(addslashes($messageTemplate->content)); ?>`;
            navigator.clipboard.writeText(content).then(function() {
                // Show success feedback
                const btn = event.target.closest('button');
                const originalText = btn.innerHTML;
                btn.innerHTML = '<i class="fas fa-check"></i> Copied!';
                btn.classList.remove('btn-outline-success');
                btn.classList.add('btn-success');
                
                setTimeout(function() {
                    btn.innerHTML = originalText;
                    btn.classList.remove('btn-success');
                    btn.classList.add('btn-outline-success');
                }, 2000);
            }).catch(function(err) {
                console.error('Failed to copy text: ', err);
                alert('Failed to copy content to clipboard');
            });
        }
    </script>
</body>
</html><?php /**PATH D:\wamp64\www\paceerror\PaceEvents\resources\views\message-templates\show.blade.php ENDPATH**/ ?>