<?php
    use Illuminate\Support\Str;
    $ticketType = $ticket->ticket_type ?? 'normal';
    $isVip = $ticketType === 'vip';
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Complimentary E-Ticket | <?php echo e($event?->venue ?? 'Pace Event'); ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-icons/1.11.3/font/bootstrap-icons.min.css" rel="stylesheet"/>
    <link href="https://fonts.googleapis.com/css2?family=Playfair+Display:wght@400;600;700&family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    
    <style>
        :root {
            <?php if($isVip): ?>
            --primary-color: #6B46C1;
            --secondary-color: #D4AF37; 
            --accent-color: #9D50BB;
            --badge-bg: linear-gradient(135deg, #6B46C1 0%, #D4AF37 100%);
            --card-bg: #ffffff;
            --pattern-color: rgba(212, 175, 55, 0.08);
            <?php else: ?>
            --primary-color: #D4AF37;
            --secondary-color: #C0C0C0;
            --accent-color: #B8860B;
            --badge-bg: linear-gradient(135deg, #D4AF37 0%, #C0C0C0 100%);
            --card-bg: #ffffff;
            --pattern-color: rgba(212, 175, 55, 0.05);
            <?php endif; ?>
            --text-dark: #212529;
            --divider: rgba(0,0,0,0.075);
        }
        
        body {
            background: #f8f9fa;
            color: var(--text-dark);
            font-family: "Inter", sans-serif;
            position: relative;
        }
        
        <?php if($isVip): ?>
        body::before {
            content: "VIP ACCESS";
            position: fixed;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%) rotate(-45deg);
            font-size: 8rem;
            font-weight: 900;
            color: rgba(107, 70, 193, 0.03);
            z-index: 0;
            pointer-events: none;
            white-space: nowrap;
            font-family: 'Playfair Display', serif;
        }
        <?php endif; ?>
        
        .ticket-wrapper{
            max-width: 500px;
            margin: 2rem auto;
            position: relative;
            z-index: 1;
        }
        
        .tickets-container{
            display: flex;
            flex-direction: column;
            gap: 2rem;
            max-width: 100%;
            margin: 2rem auto;
            padding: 0 1rem;
            position: relative;
            z-index: 1;
        }
        
        .ticket-card{
            background: var(--card-bg);
            border-radius: 1.25rem;
            overflow: hidden;
            <?php if($isVip): ?>
            box-shadow: 0 1rem 3rem rgba(107, 70, 193, 0.3), 0 0 0 3px var(--secondary-color);
            border: 2px solid transparent;
            background-image: linear-gradient(white, white), var(--badge-bg);
            background-origin: border-box;
            background-clip: padding-box, border-box;
            <?php else: ?>
            box-shadow: 0 0.75rem 2rem rgba(0,0,0,0.12);
            border: 1px solid rgba(212, 175, 55, 0.2);
            <?php endif; ?>
            position: relative;
        }
        
        .ticket-card::before {
            content: "";
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background-image: 
                repeating-linear-gradient(45deg, transparent, transparent 10px, var(--pattern-color) 10px, var(--pattern-color) 20px),
                repeating-linear-gradient(-45deg, transparent, transparent 10px, var(--pattern-color) 10px, var(--pattern-color) 20px);
            pointer-events: none;
            z-index: 0;
        }
        
        .ticket-content{
            display: flex;
            align-items: stretch;
            min-height: 220px;
            position: relative;
            z-index: 1;
        }
        
        .ticket-left{
            flex: 1;
            padding: 2rem 1.75rem;
        }
        
        .ticket-right{
            flex: 0 0 200px;
            padding: 1.75rem;
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
            <?php if($isVip): ?>
            background: linear-gradient(135deg, rgba(107, 70, 193, 0.08) 0%, rgba(212, 175, 55, 0.08) 100%);
            <?php else: ?>
            background: linear-gradient(135deg, rgba(212, 175, 55, 0.06) 0%, rgba(192, 192, 192, 0.06) 100%);
            <?php endif; ?>
            border-left: 2px dashed var(--divider);
        }
        
        @media (max-width: 768px) {
            .ticket-content {
                flex-direction: column;
                min-height: auto;
            }
            .ticket-left {
                padding: 1.5rem;
            }
            .ticket-right {
                flex: none;
                width: 100%;
                border-left: none;
                border-top: 2px dashed var(--divider);
                padding: 1.5rem;
            }
        }
        
        .complimentary-badge {
            display: inline-flex;
            align-items: center;
            gap: 0.5rem;
            background: var(--badge-bg);
            color: white;
            padding: 0.5rem 1rem;
            border-radius: 999px;
            font-size: 0.75rem;
            font-weight: 700;
            text-transform: uppercase;
            letter-spacing: 0.1em;
            margin-bottom: 1rem;
            <?php if($isVip): ?>
            box-shadow: 0 4px 12px rgba(107, 70, 193, 0.4);
            <?php else: ?>
            box-shadow: 0 3px 10px rgba(212, 175, 55, 0.3);
            <?php endif; ?>
        }
        
        .event-header{
            margin-bottom: 1.25rem;
        }
        
        .event-header img{
            width: 70px;
            height: 70px;
            object-fit: cover;
            border-radius: 0.75rem;
            border: 3px solid var(--primary-color);
            box-shadow: 0 4px 8px rgba(0,0,0,0.1);
        }
        
        .event-title {
            font-family: 'Playfair Display', serif;
            font-size: 1.35rem;
            font-weight: 700;
            color: var(--text-dark);
            margin: 0.5rem 0 0.25rem 0;
            line-height: 1.3;
        }
        
        .event-info small {
            display: block;
            color: #6c757d;
            margin-bottom: 0.25rem;
        }
        
        .chip{
            font-size: 0.7rem;
            background: #e9ecef;
            color: #6c757d;
            padding: 0.2rem 0.6rem;
            border-radius: 999px;
            text-transform: uppercase;
            letter-spacing: 0.05em;
            font-weight: 500;
        }
        
        .divider{
            border-top: 2px dashed var(--divider);
            margin: 1.25rem 0;
        }
        
        .qr-section{
            display: flex;
            flex-direction: column;
            align-items: center;
            gap: 0.75rem;
        }
        
        .qr-section img {
            width: 130px;
            height: 130px;
            border-radius: 0.5rem;
            padding: 0.5rem;
            background: white;
            <?php if($isVip): ?>
            border: 3px solid var(--primary-color);
            <?php else: ?>
            border: 2px solid var(--primary-color);
            <?php endif; ?>
        }
        
        .ticket-number-badge {
            background: var(--badge-bg);
            color: white;
            padding: 0.35rem 1rem;
            border-radius: 999px;
            font-size: 0.8rem;
            font-weight: 700;
            text-transform: uppercase;
            letter-spacing: 0.05em;
        }
        
        .details-table {
            width: 100%;
        }
        
        .details-table td{
            padding: 0.4rem 0;
            font-size: 0.95rem;
        }
        
        .details-table td:first-child {
            color: #6c757d;
            font-weight: 500;
            width: 40%;
        }
        
        .details-table td:last-child {
            font-weight: 600;
            color: var(--text-dark);
        }
        
        .copy-btn{
            cursor: pointer;
            color: var(--primary-color);
            transition: all 0.2s;
        }
        
        .copy-btn:hover {
            color: var(--accent-color);
            transform: scale(1.1);
        }
        
        .btn-download{
            border-radius: 2rem;
            font-weight: 600;
            letter-spacing: 0.03em;
            background: var(--badge-bg);
            border: none;
            color: white;
            padding: 0.75rem 1.5rem;
            transition: all 0.3s;
            <?php if($isVip): ?>
            box-shadow: 0 6px 20px rgba(107, 70, 193, 0.4);
            <?php else: ?>
            box-shadow: 0 4px 15px rgba(212, 175, 55, 0.3);
            <?php endif; ?>
        }
        
        .btn-download:hover {
            transform: translateY(-2px);
            <?php if($isVip): ?>
            box-shadow: 0 8px 25px rgba(107, 70, 193, 0.5);
            <?php else: ?>
            box-shadow: 0 6px 20px rgba(2  12, 175, 55, 0.4);
            <?php endif; ?>
        }
        
        .special-notice {
            background: var(--pattern-color);
            border-left: 4px solid var(--primary-color);
            padding: 1rem 1.25rem;
            border-radius: 0.5rem;
            margin-top: 1rem;
            font-size: 0.85rem;
            color: #495057;
        }
        
        .special-notice strong {
            color: var(--primary-color);
            font-weight: 700;
        }
        
        @media print {
            body::before {
                display: none;
            }
            .btn-download {
                display: none;
            }
        }
    </style>
</head>
<body>
    <?php if($ticket->quantity > 1): ?>
        <div class="tickets-container">
            <?php for($i = 1; $i <= $ticket->quantity; $i++): ?>
                <div class="ticket-card">
                    <div class="ticket-content">
                        <!-- Left Side - Event Info & Details -->
                        <div class="ticket-left">
                            <!-- Complimentary Badge -->
                            <div class="complimentary-badge">
                                <?php if($isVip): ?>
                                    <i class="bi bi-gem"></i>
                                    VIP GUEST
                                <?php else: ?>
                                    <i class="bi bi-gift"></i>
                                    COMPLIMENTARY
                                <?php endif; ?>
                            </div>
                            
                            <!-- Event Header -->
                            <div class="event-header d-flex gap-3 align-items-start">
                                <?php
                                    $imgPath = $event?->event_image;
                                    if ($imgPath) {
                                        $imageSrc = Str::startsWith($imgPath, ['http://','https://']) ? $imgPath : asset($imgPath);
                                    } else {
                                        $imageSrc = 'https://placehold.co/150x150?text=Event';
                                    }
                                ?>
                                <img src="<?php echo e($imageSrc); ?>" alt="event"/>
                                <div class="flex-grow-1">
                                    <span class="chip">Festival</span>
                                    <h5 class="event-title"><?php echo e($event?->title ?? 'Pace Teens Festival 2025'); ?></h5>
                                    <small><?php echo e($event?->venue ?? 'KICC Grounds, Nairobi'); ?></small>
                                    <small><?php echo e(\Carbon\Carbon::parse($event?->date)->format('M d, Y')); ?></small>
                                </div>
                            </div>
                            
                            <!-- Details Table -->
                            <table class="details-table">
                                <tr>
                                    <td>Attendee</td>
                                    <td><?php echo e($ticket->first_name ?? ''); ?> <?php echo e($ticket->last_name ?? ''); ?></td>
                                </tr>
                                <tr>
                                    <td>Ticket</td>
                                    <td><?php echo e($i); ?> of <?php echo e($ticket->quantity); ?></td>
                                </tr>
                                <tr>
                                    <td>Issued On</td>
                                    <td><?php echo e($ticket->created_at->timezone('Africa/Nairobi')->format('M d, Y')); ?></td>
                                </tr>
                                <tr>
                                    <td>Type</td>
                                    <td>
                                        <?php if($isVip): ?>
                                            <span style="color: var(--primary-color); font-weight: 700;">VIP Complimentary</span>
                                        <?php else: ?>
                                            <span style="color: var(--primary-color); font-weight: 700;">Complimentary</span>
                                        <?php endif; ?>
                                    </td>
                                </tr>
                                <tr>
                                    <td>Booking Code</td>
                                    <td>
                                        <span id="bookingCode<?php echo e($i); ?>"><?php echo e($ticket->reference); ?>-<?php echo e($i); ?></span>
                                        <i class="bi bi-clipboard copy-btn ms-2" onclick="copyCode('bookingCode<?php echo e($i); ?>')"></i>
                                    </td>
                                </tr>
                            </table>
                        </div>
                        
                        <!-- Right Side - QR Code & Download -->
                        <div class="ticket-right">
                            <div class="qr-section">
                                <div class="ticket-number-badge">Ticket <?php echo e($i); ?></div>
                                <img src="https://api.qrserver.com/v1/create-qr-code/?size=130x130&data=<?php echo e(urlencode(url('/ticket/verify/' . $ticket->reference))); ?>" alt="QR"/>
                            </div>
                            <button class="btn btn-download w-100 mt-3" onclick="downloadTicket(<?php echo e($i); ?>)">
                                <i class="bi bi-download me-2"></i>Download
                            </button>
                        </div>
                    </div>
                </div>
            <?php endfor; ?>
        </div>
    <?php else: ?>
        <div class="ticket-wrapper">
            <div class="ticket-card">
                <div class="ticket-content">
                    <!-- Left Side -->
                    <div class="ticket-left">
                        <!-- Complimentary Badge -->
                        <div class="complimentary-badge">
                            <?php if($isVip): ?>
                                <i class="bi bi-gem"></i>
                                VIP GUEST
                            <?php else: ?>
                                <i class="bi bi-gift"></i>
                                COMPLIMENTARY
                            <?php endif; ?>
                        </div>
                        
                        <!-- Event Header -->
                        <div class="event-header d-flex gap-3 align-items-start">
                            <?php
                                $imgPath = $event?->event_image;
                                if ($imgPath) {
                                    $imageSrc = Str::startsWith($imgPath, ['http://','https://']) ? $imgPath : asset($imgPath);
                                } else {
                                    $imageSrc = 'https://placehold.co/150x150?text=Event';
                                }
                            ?>
                            <img src="<?php echo e($imageSrc); ?>" alt="event"/>
                            <div class="flex-grow-1">
                                <span class="chip">Festival</span>
                                <h5 class="event-title"><?php echo e($event?->title ?? 'Pace Teens Festival 2025'); ?></h5>
                                <small><?php echo e($event?->venue ?? 'KICC Grounds, Nairobi'); ?></small>
                                <small><?php echo e(\Carbon\Carbon::parse($event?->date)->format('M d, Y')); ?></small>
                            </div>
                        </div>
                        
                        <div class="divider"></div>
                        
                        <!-- Details -->
                        <table class="details-table">
                            <tr>
                                <td>Attendee</td>
                                <td><?php echo e($ticket->first_name ?? ''); ?> <?php echo e($ticket->last_name ?? ''); ?></td>
                            </tr>
                            <tr>
                                <td>Quantity</td>
                                <td><?php echo e($ticket->quantity); ?></td>
                            </tr>
                            <tr>
                                <td>Issued On</td>
                                <td><?php echo e($ticket->created_at->timezone('Africa/Nairobi')->format('M d, Y')); ?></td>
                            </tr>
                            <tr>
                                <td>Type</td>
                                <td>
                                    <?php if($isVip): ?>
                                        <span style="color: var(--primary-color); font-weight: 700;">VIP Complimentary</span>
                                    <?php else: ?>
                                        <span style="color: var(--primary-color); font-weight: 700;">Complimentary</span>
                                    <?php endif; ?>
                                </td>
                            </tr>
                            <tr>
                                <td>Booking Code</td>
                                <td>
                                    <span id="bookingCode"><?php echo e($ticket->complimentary_code); ?></span>
                                    <i class="bi bi-clipboard copy-btn ms-2" onclick="copyCode('bookingCode')"></i>
                                </td>
                            </tr>
                        </table>
                        
                        <div class="special-notice">
                            <strong>
                                <?php if($isVip): ?>
                                    <i class="bi bi-star-fill me-2"></i>VIP Access:
                                <?php else: ?>
                                    <i class="bi bi-info-circle-fill me-2"></i>Special Guest:
                                <?php endif; ?>
                            </strong>
                            This is a <?php echo e($isVip ? 'VIP ' : ''); ?>complimentary ticket. Please present this ticket at the entrance.
                            <?php if($isVip): ?>
                                Enjoy exclusive VIP priority access.
                            <?php endif; ?>
                        </div>
                    </div>
                    
                    <!-- Right Side -->
                    <div class="ticket-right">
                        <div class="qr-section">
                            <img src="https://api.qrserver.com/v1/create-qr-code/?size=150x150&data=<?php echo e(urlencode(url('/ticket/verify/' . $ticket->reference))); ?>" alt="QR"/>
                            <small class="text-muted text-center">Scan at entrance</small>
                        </div>
                    </div>
                </div>
            </div>
            <button class="btn btn-download w-100 mt-3" onclick="window.print()">
                <i class="bi bi-download me-2"></i>Download Ticket
            </button>
        </div>
    <?php endif; ?>

    <script>
        function copyCode(elementId){
            const code = document.getElementById(elementId).innerText;
            navigator.clipboard.writeText(code).then(()=>{
                alert('Booking code copied!');
            });
        }
        
        function downloadTicket(ticketNumber) {
            const printWindow = window.open('', '_blank');
            const ticketElement = document.querySelector(`button[onclick="downloadTicket(${ticketNumber})"]`).closest('.ticket-card');
            
            printWindow.document.write(`
                <!DOCTYPE html>
                <html>
                <head>
                    <title>Complimentary Ticket ${ticketNumber}</title>
                    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
                    <link href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-icons/1.11.3/font/bootstrap-icons.min.css" rel="stylesheet"/>
                    <style>
                        body { margin: 0; padding: 20px; }
                        .ticket-card { max-width: 500px; margin: 0 auto; }
                        @media print {
                            body { margin: 0; padding: 0; }
                            .btn-download { display: none !important; }
                        }
                    </style>
                </head>
                <body>
                    ${ticketElement.outerHTML}
                </body>
                </html>
            `);
            printWindow.document.close();
            
            setTimeout(() => {
                printWindow.print();
            }, 500);
        }
    </script>
</body>
</html>
<?php /**PATH D:\wamp64\www\paceerror\PaceEvents\resources\views\ticket\complimentary-download.blade.php ENDPATH**/ ?>