<!DOCTYPE html>
<html>
<head>
    <title>Your Ticket for <?php echo e($data['eventName']); ?></title>
    <style>
        body {
            font-family: 'Arial', sans-serif;
            line-height: 1.6;
            margin: 0;
            padding: 0;
            background-color: #d29cdd;
            color: #050505;
        }
        .container {
            max-width: 600px;
            margin: 20px auto;
            background: #ffffff;
            border-radius: 8px;
            overflow: hidden;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
        }
        .header {
            background-color: #ffffff;
            padding: 30px 20px 20px;
            text-align: center;
            border-bottom: 1px solid #eeeeee;
        }
        .logo {
            height: 60px;
            width: auto;
            object-fit: contain;
            margin-bottom: 20px;
        }
        .content {
            padding: 30px;
            color: #333333;
        }
        .ticket-info {
            background: #f9f9f9;
            border-left: 4px solid #3a7bd5;
            padding: 15px;
            margin: 20px 0;
            border-radius: 0 4px 4px 0;
            color: #333333;
        }
        .footer {
            margin-top: 20px;
            padding: 20px;
            text-align: center;
            font-size: 12px;
            color: #030000;
            background: #f8f9fa;
            border-top: 1px solid #eeeeee;
        }
        .btn {
            display: inline-block;
            padding: 12px 24px;
            background: linear-gradient(to right, #3e035a, #400463);
            color: white !important;
            text-decoration: none;
            border-radius: 4px;
            font-weight: bold;
            margin: 15px 0;
        }
        .event-name {
            color: #020003;
            font-weight: bold;
            font-size: 35px;
        }
        
        /* Dark mode overrides */
        @media (prefers-color-scheme: dark) {
            .container {
                background: #0a0a0a;
                box-shadow: 0 4px 12px rgba(0, 0, 0, 0.3);
            }
            .header {
                background-color: #1a1a1a;
                border-bottom: 1px solid #333333;
            }
            .content {
                color: #ffffff;
            }
            .ticket-info {
                background: #333333;
                color: #ffffff;
            }
            .footer {
                background: #1a1a1a;
                border-top: 1px solid #333333;
                color: #aaaaaa;
            }
            .event-name {
                color: #a855f7;
            }
        }
        
        /* Fallback for email clients that don't support media queries */
        [data-theme="dark"] .container {
            background: #0a0a0a;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.3);
        }
        [data-theme="dark"] .header {
            background-color: #1a1a1a;
            border-bottom: 1px solid #333333;
        }
        [data-theme="dark"] .content {
            color: #ffffff;
        }
        [data-theme="dark"] .ticket-info {
            background: #333333;
            color: #ffffff;
        }
        [data-theme="dark"] .footer {
            background: #1a1a1a;
            border-top: 1px solid #333333;
            color: #aaaaaa;
        }
        [data-theme="dark"] .event-name {
            color: #f8f6fa;
        }
    </style>
</head>
<body>
    
        <div class="container" data-theme="light">
            <div class="header">
                <!-- Professional logo with proper sizing and spacing -->
                <img src="https://events.pacesetter.co.ke/assets/img/logo/logo.png" alt="Pacesetter Events" class="logo" style="height: 60px; width: auto;">
                <h1 style="margin: 10px 0; color: inherit;">Complimentary Ticket</h1>
            </div>
            
            <div class="content">
                <p>Dear <?php echo e($data['recipientName']); ?>,</p>
                
                <p>Welcome to:</p>
                <p class="event-name"><?php echo e($data['eventName']); ?>!!!</p>
                <p>Your ticket info:</p>
                <div class="ticket-info">
                    <p><strong>Ticket:</strong> <?php echo e($data['code']); ?></p>
                    <p><strong>Tickets #:</strong> <?php echo e($data['quantity']); ?></p>
                </div>
                
                <p>Please redeem your ticket below</p>
                
                <center>
                    <a href="<?php echo e($data['redeemUrl']); ?>" class="btn">Redeem Ticket</a>
                </center>
                
                <p>We look forward to seeing you there!</p>
                <p>Best regards,<br>The Pacesetter Events Team</p>
            </div>
            
            <div class="footer">
                <p>If you have any questions, please contact our support team at complimentary@pacesetter.co.ke</p>
                <p>&copy; 2025 Pacesetter Events. All rights reserved.</p>
                <p>
                    <a href="https://events.pacesetter.co.ke" style="color: #3a7bd5; text-decoration: none;">Website</a>
                </p>
            </div>
        </div>

     

    
        <script>
            // Client-side theme detection (for web browsers)
            if (window.matchMedia && window.matchMedia('(prefers-color-scheme: dark)').matches) {
                document.querySelector('.container').setAttribute('data-theme', 'dark');
            }
            
            // Listen for theme changes
            window.matchMedia('(prefers-color-scheme: dark)').addEventListener('change', event => {
                document.querySelector('.container').setAttribute('data-theme', event.matches ? 'dark' : 'light');
            });
        </script>
</body>
</html><?php /**PATH D:\wamp64\www\paceerror\PaceEvents\resources\views\emails\complimentary_email.blade.php ENDPATH**/ ?>