<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\TestController;
use App\Http\Controllers\Homecontroller;
use App\Http\Controllers\StkTransactionController;
/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "api" middleware group. Make something great!
|
*/

// M-Pesa callback routes
// These routes don't require CSRF protection as they're called by M-Pesa
Route::prefix('v1')->group(function () {

    Route::post('c2b-stk-callback', [TestController::class, 'handleStkCallback']);
    // Route::post('c2b-confirmation', [TestController::class, 'handleConfirmation']);
    // Route::post('c2b-validation', [TestController::class, 'handleValidation']);
    Route::post('c2b-stk-validation', [Homecontroller::class, 'validateStkPush']);
    Route::get('ticket-status/{reference}', [Homecontroller::class, 'ticketStatus']);

    Route::get('/register-mpesa-callback', [TestController::class, 'registerCallbackUrl']);

    Route::post('c2b-confirmation', [Homecontroller::class, 'handleConfirmation']);
    Route::post('c2b-validation', [Homecontroller::class, 'handleValidation']);

    // STK Transaction routes
    Route::prefix('stk-transactions')->group(function () {
        Route::post('/log', [StkTransactionController::class, 'logStkTransaction']);
        Route::get('/', [StkTransactionController::class, 'getStkTransactions']);
        Route::get('/statistics', [StkTransactionController::class, 'getStkStatistics']);
        Route::put('/{transactionId}/status', [StkTransactionController::class, 'updateStkStatus']);
    });

    // Token test route
    Route::get('/token-test', [TestController::class, 'tokenTest']);

});
