<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>User Details - Admin Panel</title>
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <meta name="description" content="PACE Events" />
        <meta name="viewport" content="width=device-width, initial-scale=1" />
        <!-- Primary Meta Tags -->
        <meta name="title" content="PACE" />
        <meta name="description" content="Welcome to Pacesetter Entertainment, Nairobi's premier party and events company. Since 2023, we have been crafting unforgettable experiences that educate, motivate, and entertain. Specializing in event management and organization across Kenya, we bring innovation and excellence to every occasion. From corporate events to private celebrations, trust us to make your events remarkable." />
    
        <!-- Open Graph / Facebook -->
        <meta property="og:type" content="website" />
        <meta property="og:url" content="https://events.pacesetter.co.ke/" />
        <meta property="og:title" content="PACE" />
        <meta property="og:description" content="Welcome to Pacesetter Entertainment, Nairobi's premier party and events company. Since 2023, we have been crafting unforgettable experiences that educate, motivate, and entertain. Specializing in event management and organization across Kenya, we bring innovation and excellence to every occasion. From corporate events to private celebrations, trust us to make your events remarkable." />
        <meta property="og:image" content="https://events.pacesetter.co.ke/assets/img/logo/logo.png" />
    
        <!-- Twitter -->
        <meta property="twitter:card" content="summary_large_image" />
        <meta property="twitter:url" content="https://events.pacesetter.co.ke/" />
        <meta property="twitter:title" content="PACE" />
        <meta property="twitter:description" content="Welcome to Pacesetter Entertainment, Nairobi's premier party and events company. Since 2023, we have been crafting unforgettable experiences that educate, motivate, and entertain. Specializing in event management and organization across Kenya, we bring innovation and excellence to every occasion. From corporate events to private celebrations, trust us to make your events remarkable." />
        <meta property="twitter:image" content="https://events.pacesetter.co.ke/assets/img/logo/logo.png" />
    
        <!-- Meta Pixel Code -->
            <script>
            !function(f,b,e,v,n,t,s)
            {if(f.fbq)return;n=f.fbq=function(){n.callMethod?
            n.callMethod.apply(n,arguments):n.queue.push(arguments)};
            if(!f._fbq)f._fbq=n;n.push=n;n.loaded=!0;n.version='2.0';
            n.queue=[];t=b.createElement(e);t.async=!0;
            t.src=v;s=b.getElementsByTagName(e)[0];
            s.parentNode.insertBefore(t,s)}(window, document,'script',
            'https://connect.facebook.net/en_US/fbevents.js');
            fbq('init', '675576561988267');
            fbq('track', 'PageView');
            </script>
            <noscript><img height="1" width="1" style="display:none"
            src="https://www.facebook.com/tr?id=675576561988267&ev=PageView&noscript=1"
            /></noscript>
            <!-- End Meta Pixel Code -->
        <link
          rel="shortcut icon"
          type="image/x-icon"
          href="assets/img/logo/logo.png"
        />
    
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Font Awesome -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    
    @vite(['resources/css/app.css', 'resources/js/app.js'])

    <style>
        :root {
            --primary-color: #0d6efd;
            --secondary-color: #6c757d;
            --success-color: #198754;
            --danger-color: #dc3545;
            --warning-color: #ffc107;
            --light-color: #f8f9fa;
            --dark-color: #212529;
        }

        .page-header {
            
            color: rgb(54, 3, 66);
            padding: 2rem 1rem;
            margin-bottom: 2rem;
            
        }

        .detail-card {
            background: white;
            border-radius: 10px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.08);
            padding: 1.5rem;
            margin-bottom: 2rem;
        }

        .detail-label {
            color: var(--secondary-color);
            font-weight: 600;
            margin-bottom: 0.5rem;
            font-size: 0.9rem;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }

        .detail-value {
            margin-bottom: 1.5rem;
            word-break: break-all;
            font-size: 1rem;
            color: var(--dark-color);
        }

        .role-badge {
            font-size: 0.75rem;
            padding: 0.35em 0.65em;
            margin-right: 0.5rem;
            margin-bottom: 0.5rem;
        }

        .user-avatar {
            width: 60px;
            height: 60px;
            border-radius: 50%;
            background: var(--primary-color);
            color: white;
            display: flex;
            align-items: center;
            justify-content: center;
            font-weight: bold;
            font-size: 1.5rem;
            margin-bottom: 1rem;
        }

        .action-buttons .btn {
            margin: 0.25rem;
        }

        @media (max-width: 768px) {
            .page-header {
                padding: 1.5rem 1rem;
                margin-bottom: 1rem;
            }

            .detail-card {
                padding: 1rem;
            }

            .user-avatar {
                width: 50px;
                height: 50px;
                font-size: 1.2rem;
            }

            .action-buttons .btn {
                width: 100%;
                margin-bottom: 0.5rem;
            }
        }

        @media (max-width: 576px) {
            .detail-card {
                padding: 0.75rem;
            }

            .detail-label {
                font-size: 0.8rem;
            }

            .detail-value {
                font-size: 0.9rem;
            }

            .action-buttons .btn {
                font-size: 0.8rem;
                padding: 0.5rem;
            }
        }
    </style>
</head>
<body class="bg-light">
    <div class="py-3 container-fluid">
        @include('layouts.navigation')

        <!-- Page Header -->
        <div class="page-header">
            <div class="row align-items-center">
                <div class="col-md-6">
                    <h1 class="mb-2 h3">
                        <i class="fas fa-user me-2"></i>User Details
                    </h1>
                    <p class="mb-0 opacity-75">
                        Detailed information for {{ $user->name }}
                    </p>
                </div>
                <div class="col-md-6 text-md-end action-buttons">
                    @can('role:super-admin')
                    <a href="{{ route('users.edit', $user->id) }}" class="btn btn-light me-2">
                        <i class="fas fa-edit me-2"></i>Edit User
                    </a>
                     @endcan
                    <a href="{{ route('users.index') }}" class="btn btn-outline-light">
                        <i class="fas fa-arrow-left me-2"></i>Back to Users
                    </a>
                   
                </div>
            </div>
        </div>

        <!-- Messages -->
        @if (session('success'))
            <div class="alert alert-success alert-dismissible fade show" role="alert">
                <i class="fas fa-check-circle me-2"></i>
                {!! session('success') !!}
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
        @endif

        @if (session('error'))
            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                <i class="fas fa-exclamation-circle me-2"></i>
                {{ session('error') }}
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
        @endif

        <!-- Permission Notice for Management -->
        @if(auth()->user()->hasRole('management') && !auth()->user()->hasRole('super-admin'))
            <div class="alert alert-info alert-dismissible fade show" role="alert">
                <i class="fas fa-info-circle me-2"></i>
                You are in <strong>View Only</strong> mode. As a Management user, you can view user information but cannot edit or delete users.
            </div>
        @endif

        <!-- User Details -->
        <div class="detail-card">
            <div class="row">
                <div class="text-center col-12">
                    <div class="mx-auto user-avatar">
                        {{ strtoupper(substr($user->name, 0, 1)) }}
                    </div>
                    <h4 class="mb-3">{{ $user->name }}</h4>
                    <div class="mb-3">
                        @foreach($user->roles as $role)
                            <span class="badge role-badge bg-primary">{{ $role->name }}</span>
                        @endforeach
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-md-6">
                    <div class="detail-label">User ID</div>
                    <div class="detail-value">#{{ $user->id }}</div>

                    <div class="detail-label">Email</div>
                    <div class="detail-value">{{ $user->email }}</div>

                    <div class="detail-label">Phone</div>
                    <div class="detail-value">{{ $user->phone ?? 'N/A' }}</div>

                    @can('role:super-admin')
                    <div class="detail-label">Password (Hashed)</div>
                    <div class="detail-value">{{ $user->password }}</div>
                    @endcan
                </div>
                <div class="col-md-6">
                    <div class="detail-label">Created At</div>
                    <div class="detail-value">{{ $user->created_at->format('M j, Y H:i:s') }}</div>

                    <div class="detail-label">Updated At</div>
                    <div class="detail-value">{{ $user->updated_at->format('M j, Y H:i:s') }}</div>

                    <div class="detail-label">Email Verified At</div>
                    <div class="detail-value">{{ $user->email_verified_at ? $user->email_verified_at->format('M j, Y H:i:s') : 'Not Verified' }}</div>

                    <div class="detail-label">Roles</div>
                    <div class="detail-value">
                        @forelse($user->roles as $role)
                            <span class="badge role-badge bg-primary">{{ $role->name }}</span>
                        @empty
                            <span class="text-muted">No roles assigned</span>
                        @endforelse
                    </div>
                </div>
            </div>
            @can('role:super-admin')
            <div class="mt-4 text-end action-buttons">
                <form action="{{ route('users.destroy', $user->id) }}" method="POST" class="d-inline">
                    @csrf
                    @method('DELETE')
                    <button type="submit" class="btn btn-danger" onclick="return confirm('Are you sure you want to delete this user?')">
                        <i class="fas fa-trash me-2"></i>Delete User
                    </button>
                </form>
            </div>
            @endcan
        </div>
    </div>

    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>

    <script>
        // Auto-dismiss alerts after 5 seconds
        document.addEventListener('DOMContentLoaded', function() {
            const alerts = document.querySelectorAll('.alert');
            alerts.forEach(alert => {
                setTimeout(() => {
                    const bsAlert = new bootstrap.Alert(alert);
                    bsAlert.close();
                }, 5000);
            });
        });
    </script>
</body>
</html>