<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Pace Setter - Scanner</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Arial', sans-serif;
            min-height: 100vh;
            display: flex;
            justify-content: center;
            align-items: center;
            background: #f5f5f5;
            padding: 20px;
        }

        .container {
            background: white;
            border-radius: 15px;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.2);
            text-align: center;
            max-width: 700px;
            width: 100%;
            overflow: hidden;
            max-height: 9000px;
        }

        .banner {
            width: 100%;
            height: 180px;
            position: relative;
            overflow: hidden;
        }

        .banner-image {
            width: 100%;
            height: 100%;
            object-fit: cover;
            object-position: center; /* This crops to show the top part of the image */
        }

        .banner-overlay {
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: auto;
            background: rgba(102, 126, 234, 0.1);
            display: flex;
            flex-direction: column;
            justify-content: center;
            align-items: center;
            padding: 20px;
        }

        .logo-container {
            margin-bottom: 10px;
        }

        .logo {
            width: 60px;
            height: auto;
            filter: brightness(0) invert(1);
            backdrop-filter: blur(5px);
        }

        .banner-title {
            font-size: 24px;
            font-weight: bold;
            color: white;
            text-shadow: 2px 2px 4px rgba(0, 0, 0, 0.5);
            margin-bottom: 5px;
        }

        .banner-subtitle {
            font-size: 14px;
            color: white;
            text-shadow: 1px 1px 3px rgba(0, 0, 0, 0.5);
            opacity: 0.9;
        }

        .content {
            padding: 30px 25px;
        }

        .welcome-message {
            color: #667eea;
            font-size: 20px;
            font-weight: bold;
            margin-bottom: 15px;
        }

        .user-name {
            color: #764ba2;
            font-size: 22px;
            font-weight: bold;
            text-transform: uppercase;
            margin: 10px 0;
            display: block;
            word-break: break-word;
        }

        .welcome-title {
            color: #333;
            margin-bottom: 20px;
            font-size: 22px;
            line-height: 1.4;
        }

        .instructions {
            color: #764ba2;
            font-size: 30px;
            line-height: 1.6;
            margin-top: 20px;
            padding: 15px;
            border-radius: 8px;
           
        }

        /* Mobile Responsive Styles */
        @media (max-width: 768px) {
            body {
                padding: 15px;
            }

            .container {
                max-width: 100%;
                border-radius: 12px;
            }

            .banner {
                height: 150px;
            }

            .banner-title {
                font-size: 20px;
            }

            .banner-subtitle {
                font-size: 12px;
            }

            .logo {
                width: 50px;
            }

            .content {
                padding: 25px 20px;
            }

            .welcome-message {
                font-size: 18px;
            }

            .user-name {
                font-size: 20px;
            }

            .welcome-title {
                font-size: 20px;
            }

            .instructions {
                font-size: 14px;
                padding: 12px;
            }
        }

        @media (max-width: 480px) {
            body {
                padding: 10px;
            }

            .banner {
                height: 120px;
            }

            .banner-title {
                font-size: 18px;
            }

            .banner-subtitle {
                font-size: 11px;
            }

            .logo {
                width: 40px;
            }

            .content {
                padding: 20px 15px;
            }

            .welcome-message {
                font-size: 16px;
            }

            .user-name {
                font-size: 18px;
            }

            .welcome-title {
                font-size: 18px;
                margin-bottom: 15px;
            }

            .instructions {
                font-size: 18px;
                margin-top: 15px;
            }
        }

        @media (max-width: 320px) {
            .banner {
                height: 100px;
            }

            .banner-title {
                font-size: 16px;
            }

            .content {
                padding: 15px 10px;
            }

            .welcome-message {
                font-size: 15px;
            }

            .user-name {
                font-size: 16px;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <!-- Banner Section with Image -->
        <div class="banner">
            <img src="{{ asset('assets/img/hero/hero-2/1744413862_nibenip_by_slnbnsintention_dhkpwtc_copy.jpg') }}" alt="Pace Setter Banner" class="banner-image">
            <div class="banner-overlay">
            </div>
        </div>
        
        <!-- Content Section -->
        <div class="content">
            <div class="welcome-message">
                <span class="user-name">{{$user->name}}</span>
            </div>            
            <div class="instructions">
               Open your camera or your QR code scanner to scan tickets
            </div>
        </div>
    </div>
</body>
</html>