<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>User Management - Admin Panel</title>
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <meta name="description" content="PACE Events" />
        <meta name="viewport" content="width=device-width, initial-scale=1" />
        <!-- Primary Meta Tags -->
        <meta name="title" content="PACE" />
        <meta name="description" content="Welcome to Pacesetter Entertainment, Nairobi's premier party and events company. Since 2023, we have been crafting unforgettable experiences that educate, motivate, and entertain. Specializing in event management and organization across Kenya, we bring innovation and excellence to every occasion. From corporate events to private celebrations, trust us to make your events remarkable." />
    
        <!-- Open Graph / Facebook -->
        <meta property="og:type" content="website" />
        <meta property="og:url" content="https://events.pacesetter.co.ke/" />
        <meta property="og:title" content="PACE" />
        <meta property="og:description" content="Welcome to Pacesetter Entertainment, Nairobi's premier party and events company. Since 2023, we have been crafting unforgettable experiences that educate, motivate, and entertain. Specializing in event management and organization across Kenya, we bring innovation and excellence to every occasion. From corporate events to private celebrations, trust us to make your events remarkable." />
        <meta property="og:image" content="https://events.pacesetter.co.ke/assets/img/logo/logo.png" />
    
        <!-- Twitter -->
        <meta property="twitter:card" content="summary_large_image" />
        <meta property="twitter:url" content="https://events.pacesetter.co.ke/" />
        <meta property="twitter:title" content="PACE" />
        <meta property="twitter:description" content="Welcome to Pacesetter Entertainment, Nairobi's premier party and events company. Since 2023, we have been crafting unforgettable experiences that educate, motivate, and entertain. Specializing in event management and organization across Kenya, we bring innovation and excellence to every occasion. From corporate events to private celebrations, trust us to make your events remarkable." />
        <meta property="twitter:image" content="https://events.pacesetter.co.ke/assets/img/logo/logo.png" />
    

        <!-- Meta Pixel Code -->
            <script>
            !function(f,b,e,v,n,t,s)
            {if(f.fbq)return;n=f.fbq=function(){n.callMethod?
            n.callMethod.apply(n,arguments):n.queue.push(arguments)};
            if(!f._fbq)f._fbq=n;n.push=n;n.loaded=!0;n.version='2.0';
            n.queue=[];t=b.createElement(e);t.async=!0;
            t.src=v;s=b.getElementsByTagName(e)[0];
            s.parentNode.insertBefore(t,s)}(window, document,'script',
            'https://connect.facebook.net/en_US/fbevents.js');
            fbq('init', '675576561988267');
            fbq('track', 'PageView');
            </script>
            <noscript><img height="1" width="1" style="display:none"
            src="https://www.facebook.com/tr?id=675576561988267&ev=PageView&noscript=1"
            /></noscript>
            <!-- End Meta Pixel Code -->
    
        <link
          rel="shortcut icon"
          type="image/x-icon"
          href="assets/img/logo/logo.png"
        />
    
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Font Awesome -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    
    @vite(['resources/css/app.css', 'resources/js/app.js'])

    <style>
        :root {
            --primary-color: #0d6efd;
            --secondary-color: #6c757d;
            --success-color: #198754;
            --danger-color: #dc3545;
            --warning-color: #ffc107;
            --light-color: #f8f9fa;
            --dark-color: #212529;
        }

        .page-header {
            
            color: rgb(54, 3, 66);
            padding: 2rem 1rem;
            margin-bottom: 2rem;
            
        }

        .user-card {
            background: white;
            border-radius: 10px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.08);
            transition: transform 0.2s ease, box-shadow 0.2s ease;
            margin-bottom: 1rem;
            border: none;
        }

        .user-card:hover {
            transform: translateY(-2px);
            box-shadow: 0 4px 15px rgba(0,0,0,0.15);
        }

        .role-badge {
            font-size: 0.75rem;
            padding: 0.35em 0.65em;
        }

        .action-buttons .btn {
            margin: 0.1rem;
            font-size: 0.875rem;
        }

        .table-responsive {
            border-radius: 10px;
            overflow: hidden;
        }

        .table th {
            background-color: var(--primary-color);
            color: white;
            border: none;
            padding: 1rem 0.75rem;
            font-weight: 600;
        }

        .table td {
            padding: 1rem 0.75rem;
            vertical-align: middle;
            border-color: #dee2e6;
        }

        .pagination .page-link {
            color: var(--primary-color);
            border: 1px solid #dee2e6;
        }

        .pagination .page-item.active .page-link {
            background-color: var(--primary-color);
            border-color: var(--primary-color);
            color: white;
        }

        .stats-card {
            background: white;
            border-radius: 10px;
            padding: 1.5rem;
            box-shadow: 0 2px 10px rgba(0,0,0,0.08);
            text-align: center;
            margin-bottom: 1.5rem;
        }

        .stats-number {
            font-size: 2rem;
            font-weight: bold;
            color: var(--primary-color);
            margin-bottom: 0.5rem;
        }

        .stats-label {
            color: var(--secondary-color);
            font-size: 0.875rem;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }

        .mobile-user-card {
            display: none;
        }

        .view-only-badge {
            background-color: var(--secondary-color);
            color: white;
            padding: 0.5rem 1rem;
            border-radius: 5px;
            font-size: 0.875rem;
        }

        .debug-info {
            background: var(--warning-color);
            color: var(--dark-color);
            padding: 1rem;
            border-radius: 5px;
            margin-bottom: 1rem;
            font-size: 0.9rem;
        }

        @media (max-width: 768px) {
            .desktop-table {
                display: none;
            }
            
            .mobile-user-card {
                display: block;
            }
            
            .page-header {
                padding: 1.5rem 1rem;
                margin-bottom: 1rem;
            }
            
            .action-buttons {
                text-align: center;
                margin-top: 1rem;
            }
            
            .action-buttons .btn {
                display: inline-block;
                margin: 0.25rem;
                min-width: 80px;
            }
            
            .navigation-row .btn {
                margin-bottom: 0.5rem;
                font-size: 0.875rem;
                padding: 0.5rem 0.75rem;
            }

            .view-only-badge {
                display: block;
                text-align: center;
                margin-top: 1rem;
            }
        }

        @media (max-width: 576px) {
            .stats-card {
                padding: 1rem;
            }
            
            .stats-number {
                font-size: 1.5rem;
            }
            
            .navigation-row {
                flex-direction: column;
                align-items: stretch;
            }
            
            .navigation-row .btn {
                margin-bottom: 0.5rem;
                text-align: center;
            }

            .action-buttons .btn {
                min-width: 70px;
                font-size: 0.8rem;
                padding: 0.4rem 0.6rem;
            }
        }

        .empty-state {
            text-align: center;
            padding: 3rem 1rem;
            color: var(--secondary-color);
        }

        .empty-state i {
            font-size: 4rem;
            margin-bottom: 1rem;
            opacity: 0.5;
        }

        .user-avatar {
            width: 40px;
            height: 40px;
            border-radius: 50%;
            background: var(--primary-color);
            color: white;
            display: flex;
            align-items: center;
            justify-content: center;
            font-weight: bold;
            font-size: 1rem;
        }

        .permission-indicator {
            position: absolute;
            top: 1rem;
            right: 1rem;
            font-size: 0.75rem;
        }
    </style>
</head>
<body class="bg-light">
    <div class="py-3 container-fluid">
        @include('layouts.navigation')
        
        <!-- Page Header -->
        <div class="page-header position-relative">
            @if(auth()->user()->hasRole('management'))
                <div class="permission-indicator">
                    <span class="badge bg-warning text-dark">
                        <i class="fas fa-eye me-1"></i>View Only
                    </span>
                </div>
            @endif
            
            <div class="row align-items-center">
                <div class="col-md-6">
                    <h1 class="mb-2 h3">
                        <i class="fas fa-users me-2"></i>User Management
                    </h1>
                    <p class="mb-0 opacity-75">
                        @if(auth()->user()->hasRole('super-admin|admin'))
                            Manage system users and their permissions
                        @else
                            View system users and their roles
                        @endif
                    </p>
                </div>
                <div class="col-md-6 text-md-end">
                    @role('super-admin|admin')
                    <a href="{{ route('users.new') }}" class="btn btn-primary btn-sm">
                        <i class="fas fa-plus me-2"></i>Add New User
                    </a>
                    @endrole
                </div>
            </div>
        </div>

        {{-- <!-- Navigation Cards -->
        <div class="mb-4 row">
            <div class="col-12">
                <div class="shadow-sm card">
                    <div class="py-3 card-body">
                        <div class="flex-wrap gap-3 d-flex justify-content-evenly align-items-center">
                            @can('view-users')
                            <a href="{{ route('users.index') }}" class="btn btn-primary @if(Route::currentRouteName() == 'users.index') active @endif">
                                <i class="fas fa-users"></i> Users
                            </a>
                            @endcan
                            @can('view-tickets')
                            <a href="{{ route('tickets.index') }}" class="btn btn-primary @if(Route::currentRouteName() == 'tickets.index') active @endif">
                                <i class="fas fa-list"></i> All Tickets
                            </a>
                            @endcan
                            @can('view-metrics')
                            <a href="{{ route('tickets.analytics') }}" class="btn btn-outline-primary @if(Route::currentRouteName() == 'tickets.analytics') active @endif">
                                <i class="fas fa-chart-bar"></i> Analytics
                            </a>
                            @endcan
                            @can('access-messages')
                            <a href="{{ route('sms.index') }}" class="btn btn-outline-secondary @if(Route::currentRouteName() == 'sms.index') active @endif">
                                <i class="fas fa-sms"></i> SMS Manager
                            </a>
                            @endcan
                            @can('access-complimentary')
                            <a href="{{ route('complimentary.tickets.index') }}" class="btn btn-outline-dark @if(Route::currentRouteName() == 'complimentary.tickets.index') active @endif">
                                <i class="fas fa-home"></i> Manage Complimentary tickets
                            </a>
                            @endcan
                        </div>
                    </div>
                </div>
            </div>
        </div> --}}

        <!-- Stats Cards -->
        {{-- <div class="mb-4 row">
            <div class="col-md-3 col-6">
                <div class="stats-card">
                    <div class="stats-number">{{ $users->total() }}</div>
                    <div class="stats-label">Total Users</div>
                </div>
            </div>
            <div class="col-md-3 col-6">
                <div class="stats-card">
                    <div class="stats-number">{{ $users->count() }}</div>
                    <div class="stats-label">Current Page</div>
                </div>
            </div>
            <div class="col-md-3 col-6">
                <div class="stats-card">
                    <div class="stats-number">{{ $users->perPage() }}</div>
                    <div class="stats-label">Per Page</div>
                </div>
            </div>
            <div class="col-md-3 col-6">
                <div class="stats-card">
                    <div class="stats-number">{{ $users->currentPage() }}</div>
                    <div class="stats-label">Current Page</div>
                </div>
            </div>
        </div> --}}

        <!-- Messages -->
        @if (session('success'))
            <div class="alert alert-success alert-dismissible fade show" role="alert">
                <i class="fas fa-check-circle me-2"></i>
                {!! session('success') !!}
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
        @endif

        @if (session('error'))
            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                <i class="fas fa-exclamation-circle me-2"></i>
                {{ session('error') }}
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
        @endif

        <!-- Permission Notice for Management -->
        @if(auth()->user()->hasRole('management') && !auth()->user()->hasRole('super-admin|admin'))
            <div class="alert alert-info alert-dismissible fade show" role="alert">
                <i class="fas fa-info-circle me-2"></i>
                You are in <strong>View Only</strong> mode. As a Management user, you can view user information but cannot create, edit, or delete users.
            </div>
        @endif

        <!-- Desktop Table -->
        <div class="shadow-sm card desktop-table">
            <div class="py-3 bg-white card-header">
                <h5 class="mb-0">
                    <i class="fas fa-list me-2"></i>Users List
                    @if(auth()->user()->hasRole('management') && !auth()->user()->hasRole('super-admin|admin'))
                        <small class="text-muted">(View Only)</small>
                    @endif
                </h5>
            </div>
            <div class="p-0 card-body">
                <div class="table-responsive">
                    <table class="table mb-0 table-hover">
                        <thead>
                            <tr>
                                <th width="60">ID</th>
                                <th>User</th>
                                <th>Contact</th>
                                <th>Roles</th>
                                <th width="250">Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse ($users as $user)
                                <tr>
                                    <td class="fw-bold">#{{ $user->id }}</td>
                                    <td>
                                        <div class="d-flex align-items-center">
                                            <div class="user-avatar me-3">
                                                {{ strtoupper(substr($user->name, 0, 1)) }}
                                            </div>
                                            <div>
                                                <div class="fw-bold">{{ $user->name }}</div>
                                                <small class="text-muted">Registered: {{ $user->created_at->format('M j, Y') }}</small>
                                            </div>
                                        </div>
                                    </td>
                                    <td>
                                        <div class="mb-1">
                                            <i class="fas fa-phone me-2 text-muted"></i>
                                            {{ $user->phone }}
                                        </div>
                                        <div>
                                            <i class="fas fa-envelope me-2 text-muted"></i>
                                            {{ $user->email }}
                                        </div>
                                    </td>
                                    <td>
                                        @foreach($user->roles as $role)
                                            <span class="mb-1 badge role-badge bg-primary me-1">
                                                {{ $role->name }}
                                            </span>
                                        @endforeach
                                    </td>
                                    <td class="action-buttons">
    <!-- View button - available to anyone who can view users -->
    @can('view-users')
        <a href="{{ route('users.show', $user->id) }}" class="btn btn-sm btn-outline-secondary">
            <i class="fas fa-eye me-1"></i>View
        </a>
    @endcan

    <!-- Edit button - available to super-admin and admin -->
    @can('edit-users')
        <a href="{{ route('users.edit', $user->id) }}" class="btn btn-sm btn-outline-primary">
            <i class="fas fa-edit me-1"></i>Edit
        </a>
    @endcan

    <!-- Delete button - available ONLY to super-admin -->
    @can('delete-users')
        <form action="{{ route('users.destroy', $user->id) }}" method="POST" class="d-inline">
            @csrf
            @method('DELETE')
            <button type="submit" class="btn btn-sm btn-outline-danger" onclick="return confirm('Are you sure you want to delete this user?')">
                <i class="fas fa-trash me-1"></i>Delete
            </button>
        </form>
    @endcan

    <!-- View only indicator for management -->
    @role('management')
        @unless(auth()->user()->hasRole('super-admin|admin'))
            <span class="view-only-badge">
                <i class="fas fa-eye me-1"></i>View Only
            </span>
        @endunless
    @endrole
</td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="5" class="py-4 text-center">
                                        <div class="empty-state">
                                            <i class="fas fa-users"></i>
                                            <h4 class="mt-3">No Users Found</h4>
                                            <p class="text-muted">No users have been created yet.</p>
                                            @role('super-admin')
                                            <a href="{{ route('users.new') }}" class="mt-3 btn btn-primary">
                                                <i class="fas fa-plus me-2"></i>Add New User
                                            </a>
                                            @endrole
                                        </td>
                                    </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
            </div>
        </div>

        <!-- Mobile Cards -->
        <div class="mobile-user-card">
            @forelse ($users as $user)
                <div class="mb-3 card user-card">
                    <div class="card-body">
                        <div class="row align-items-center">
                            <div class="col-2">
                                <div class="user-avatar">
                                    {{ strtoupper(substr($user->name, 0, 1)) }}
                                </div>
                            </div>
                            <div class="col-10">
                                <h6 class="mb-1 fw-bold">{{ $user->name }}</h6>
                                <p class="mb-1 text-muted small">
                                    <i class="fas fa-phone me-1"></i>{{ $user->phone }}
                                </p>
                                <p class="mb-2 text-muted small">
                                    <i class="fas fa-envelope me-1"></i>{{ $user->email }}
                                </p>
                                <div class="mb-2">
                                    @foreach($user->roles as $role)
                                        <span class="badge role-badge bg-primary me-1">
                                            {{ $role->name }}
                                        </span>
                                    @endforeach
                                </div>
                                <div class="action-buttons">
                                    @role('super-admin')
                                        <!-- Super Admin: Full Access -->
                                        <a href="{{ route('users.show', $user->id) }}" class="btn btn-sm btn-outline-secondary">
                                            <i class="fas fa-eye"></i> View
                                        </a>
                                        <a href="{{ route('users.edit', $user->id) }}" class="btn btn-sm btn-outline-primary">
                                            <i class="fas fa-edit"></i> Edit
                                        </a>
                                        <form action="{{ route('users.destroy', $user->id) }}" method="POST" class="d-inline">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="btn btn-sm btn-outline-danger" onclick="return confirm('Are you sure you want to delete this user?')">
                                                <i class="fas fa-trash"></i> Delete
                                            </button>
                                        </form>
                                    @elserole('management')
                                        <!-- Management: View Only -->
                                        <a href="{{ route('users.show', $user->id) }}" class="btn btn-sm btn-outline-secondary">
                                            <i class="fas fa-eye"></i> View
                                        </a>
                                        <span class="view-only-badge">
                                            <i class="fas fa-eye me-1"></i>View Only
                                        </span>
                                    @endrole
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            @empty
                <div class="card">
                    <div class="card-body">
                        <div class="empty-state">
                            <i class="fas fa-users"></i>
                            <h4 class="mt-3">No Users Found</h4>
                            <p class="text-muted">No users have been created yet.</p>
                            @role('super-admin')
                            <a href="{{ route('users.new') }}" class="mt-3 btn btn-primary">
                                <i class="fas fa-plus me-2"></i>Add New User
                            </a>
                            @endrole
                        </div>
                    </div>
                </div>
            @endforelse
        </div>

        <!-- Pagination -->
        @if($users->hasPages())
        <div class="mt-4 row">
            <div class="col-12">
                <div class="flex-wrap d-flex justify-content-between align-items-center">
                    <div class="mb-2 text-muted mb-md-0">
                        Showing {{ $users->firstItem() }} to {{ $users->lastItem() }} of {{ $users->total() }} users
                    </div>
                    <div>
                        {{ $users->links() }}
                    </div>
                </div>
            </div>
        </div>
        @endif
    </div>

    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>

    <script>
        // Auto-dismiss alerts after 5 seconds
        document.addEventListener('DOMContentLoaded', function() {
            const alerts = document.querySelectorAll('.alert');
            alerts.forEach(alert => {
                setTimeout(() => {
                    const bsAlert = new bootstrap.Alert(alert);
                    bsAlert.close();
                }, 5000);
            });
        });
    </script>
</body>
</html>