<!DOCTYPE html>
<html>
<head>
    <title>Complimentary Ticket - {{ $ticket->event->name }}</title>
    <style>
        body { font-family: Arial, sans-serif; }
        .ticket { border: 2px dashed #000; padding: 20px; max-width: 600px; margin: 0 auto; }
        .header { text-align: center; margin-bottom: 20px; }
        .qr-code { text-align: center; margin: 20px 0; }
        .details { margin-bottom: 20px; }
        .footer { text-align: center; font-size: 12px; margin-top: 20px; }
    </style>
    
</head>
<body>
    <div class="ticket">
        <div class="header">
            <h1>{{ $ticket->event->name }}</h1>
            <h3>COMPLIMENTARY TICKET</h3>
        </div>
        
        <div class="details">
            <p><strong>Name:</strong> {{ $ticket->first_name }} {{ $ticket->last_name }}</p>
            <p><strong>Event Date:</strong> {{ $ticket->event->date->format('F j, Y') }}</p>
            <p><strong>Venue:</strong> {{ $ticket->event->venue }}</p>
            <p><strong>Reference:</strong> {{ $ticket->reference }}</p>
        </div>
        
        <div class="qr-code">
            <!-- QR code with ticket reference -->
            <img src="data:image/png;base64, {!! base64_encode(QrCode::format('png')->size(150)->generate($ticket->reference)) !!}">
        </div>
        
        <div class="footer">
            <p>This complimentary ticket is valid for one entry only.</p>
            <p>Present this ticket at the venue for admission.</p>
        </div>
    </div>
</body>
</html>