<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>SMS Logs - Message History</title>
    <meta name="csrf-token" content="{{ csrf_token() }}">
    
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Font Awesome -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <!-- DataTables CSS -->
    <link href="https://cdn.datatables.net/1.13.7/css/dataTables.bootstrap5.min.css" rel="stylesheet">
    <link href="https://cdn.datatables.net/responsive/2.5.0/css/responsive.bootstrap5.min.css" rel="stylesheet">
    <link href="https://cdn.datatables.net/buttons/2.4.2/css/buttons.bootstrap5.min.css" rel="stylesheet">
    
    <style>
        .logs-container {
            max-width: 1400px;
            margin: 0 auto;
            padding: 1.5rem;
        }
        
        .stats-card {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            border-radius: 10px;
            padding: 1.5rem;
            margin-bottom: 2rem;
        }
        
        .log-card {
            border: 1px solid #dee2e6;
            border-radius: 8px;
            padding: 1rem;
            margin-bottom: 1rem;
            background: #fff;
            transition: all 0.3s ease;
        }
        
        .log-card:hover {
            box-shadow: 0 2px 8px rgba(0,0,0,0.1);
        }
        
        .btn-primary {
            background-color: #6c04f5;
            border-color: #6c04f5;
        }
        
        .btn-primary:hover {
            background-color: #5a03d1;
            border-color: #5a03d1;
        }
        
        .search-filters {
            background: #f8f9fa;
            border-radius: 10px;
            padding: 1.5rem;
            margin-bottom: 2rem;
        }
        
        .message-content {
            background: #f8f9fa;
            border-radius: 6px;
            padding: 0.75rem;
            font-size: 0.9rem;
            max-height: 100px;
            overflow-y: auto;
        }
        
        .status-sent {
            background-color: #d4edda;
            color: #155724;
        }
        
        .status-failed {
            background-color: #f8d7da;
            color: #721c24;
        }
        
        .status-pending {
            background-color: #fff3cd;
            color: #856404;
        }
        
        .campaign-badge {
            font-size: 0.7rem;
            padding: 0.25rem 0.5rem;
        }
        
        .log-table {
            background: white;
            border-radius: 10px;
            overflow: hidden;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
        }
        
        .table th {
            background-color: #f8f9fa;
            border: none;
            font-weight: 600;
        }
        
        .pagination {
            --bs-pagination-padding-x: 0.75rem;
            --bs-pagination-padding-y: 0.375rem;
            --bs-pagination-font-size: 0.875rem;
            --bs-pagination-color: #6c04f5;
            --bs-pagination-bg: #fff;
            --bs-pagination-border-width: 1px;
            --bs-pagination-border-color: #dee2e6;
            --bs-pagination-border-radius: 0.375rem;
            --bs-pagination-hover-color: #5a03d1;
            --bs-pagination-hover-bg: #f8f9ff;
            --bs-pagination-hover-border-color: #6c04f5;
            --bs-pagination-focus-color: #5a03d1;
            --bs-pagination-focus-bg: #f8f9ff;
            --bs-pagination-focus-box-shadow: 0 0 0 0.25rem rgba(108, 4, 245, 0.25);
            --bs-pagination-active-color: #fff;
            --bs-pagination-active-bg: #6c04f5;
            --bs-pagination-active-border-color: #6c04f5;
            --bs-pagination-disabled-color: #6c757d;
            --bs-pagination-disabled-bg: #fff;
            --bs-pagination-disabled-border-color: #dee2e6;
        }
        
        .pagination .page-link {
            border-radius: 0.375rem !important;
            margin: 0 0.125rem;
        }
        
        /* DataTables Custom Styling */
        .dataTables_wrapper .dataTables_length,
        .dataTables_wrapper .dataTables_filter,
        .dataTables_wrapper .dataTables_info,
        .dataTables_wrapper .dataTables_processing,
        .dataTables_wrapper .dataTables_paginate {
            margin: 0.5rem 0;
        }
        
        .dataTables_wrapper .dataTables_length select {
            border: 1px solid #dee2e6;
            border-radius: 0.375rem;
            padding: 0.375rem 0.75rem;
        }
        
        .dataTables_wrapper .dataTables_filter input {
            border: 1px solid #dee2e6;
            border-radius: 0.375rem;
            padding: 0.375rem 0.75rem;
        }
        
        .dataTables_wrapper .dataTables_paginate .paginate_button {
            border-radius: 0.375rem !important;
            margin: 0 0.125rem;
        }
        
        .dataTables_wrapper .dataTables_paginate .paginate_button.current {
            background: #6c04f5 !important;
            border-color: #6c04f5 !important;
            color: white !important;
        }
        
        .dataTables_wrapper .dataTables_paginate .paginate_button:hover {
            background: #5a03d1 !important;
            border-color: #5a03d1 !important;
            color: white !important;
        }
        
        /* Responsive adjustments */
        @media (max-width: 768px) {
            .dataTables_wrapper .dataTables_length,
            .dataTables_wrapper .dataTables_filter {
                text-align: left;
                margin-bottom: 0.5rem;
            }
        }
    </style>
</head>
<body class="bg-light">
    <div class="container logs-container">
        <!-- Header -->
        <div class="text-center mb-4">
            <h1 class="h2 mb-3">
                <i class="fas fa-history text-primary"></i>
                SMS Logs
            </h1>
            <p class="text-muted">Track and manage your SMS campaign history</p>
        </div>

        <!-- SMS Stats -->
        <div class="stats-card">
            <div class="row text-center">
                <div class="col-6 col-md-3">
                    <h4><i class="fas fa-envelope"></i> {{ number_format($stats['total_messages']) }}</h4>
                    <p class="mb-0">Total Messages</p>
                </div>
                <div class="col-6 col-md-3">
                    <h4><i class="fas fa-paper-plane"></i> {{ number_format($stats['sent_today']) }}</h4>
                    <p class="mb-0">Sent Today</p>
                </div>
                <div class="col-6 col-md-3">
                    <h4><i class="fas fa-exclamation-triangle"></i> {{ number_format($stats['failed_today']) }}</h4>
                    <p class="mb-0">Failed Today</p>
                </div>
                <div class="col-6 col-md-3">
                    <h4><i class="fas fa-money-bill"></i> KSH {{ number_format($stats['total_cost_today'], 2) }}</h4>
                    <p class="mb-0">Cost Today</p>
                </div>
            </div>
        </div>

        <!-- Navigation -->
        <div class="row mb-3">
            <div class="col-md-6">
                <div class="btn-group" role="group">
                    <a href="{{ route('sms.index') }}" class="btn btn-outline-primary">
                        <i class="fas fa-users"></i> Contacts
                    </a>
                    <a href="{{ route('sms.logs') }}" class="btn btn-primary">
                        <i class="fas fa-history"></i> SMS Logs
                    </a>
                </div>
            </div>
            <div class="col-md-6 text-end">
                <div class="btn-group">
                    <a href="{{ route('sms.export', request()->query()) }}" class="btn btn-outline-success">
                        <i class="fas fa-download"></i> Export CSV
                    </a>
                    <a href="/" class="btn btn-outline-dark">
                        <i class="fas fa-home"></i> Home
                    </a>
                </div>
            </div>
        </div>

        <!-- Search and Filters -->
        <div class="search-filters">
            <form method="GET" action="{{ route('sms.logs') }}" id="filter-form">
                <div class="row align-items-end">
                    <div class="col-md-4">
                        <label for="campaign" class="form-label">Filter by Campaign</label>
                        <select class="form-select" id="campaign" name="campaign">
                            <option value="">All Campaigns</option>
                            @foreach($campaigns as $campaignName)
                                <option value="{{ $campaignName }}" {{ $campaign === $campaignName ? 'selected' : '' }}>
                                    {{ $campaignName }}
                                </option>
                            @endforeach
                        </select>
                    </div>
                    <div class="col-md-3">
                        <label for="status" class="form-label">Filter by Status</label>
                        <select class="form-select" id="status" name="status">
                            <option value="">All Statuses</option>
                            <option value="sent" {{ $status === 'sent' ? 'selected' : '' }}>Sent</option>
                            <option value="failed" {{ $status === 'failed' ? 'selected' : '' }}>Failed</option>
                            <option value="pending" {{ $status === 'pending' ? 'selected' : '' }}>Pending</option>
                        </select>
                    </div>
                    <div class="col-md-2">
                        <label for="per_page" class="form-label">Per Page</label>
                        <select class="form-select" id="per_page" name="per_page">
                            <option value="25" {{ $perPage == 25 ? 'selected' : '' }}>25</option>
                            <option value="50" {{ $perPage == 50 ? 'selected' : '' }}>50</option>
                            <option value="100" {{ $perPage == 100 ? 'selected' : '' }}>100</option>
                            <option value="200" {{ $perPage == 200 ? 'selected' : '' }}>200</option>
                        </select>
                    </div>
                    <div class="col-md-3">
                        <button type="submit" class="btn btn-outline-primary me-2">
                            <i class="fas fa-search"></i> Filter
                        </button>
                        <a href="{{ route('sms.logs') }}" class="btn btn-outline-secondary">
                            <i class="fas fa-times"></i> Clear
                        </a>
                    </div>
                </div>
            </form>
        </div>

        <!-- SMS Logs Table -->
        <div class="log-table">
            <div class="table-responsive">
                <table class="table table-hover mb-0" id="smsLogsTable">
                    <thead>
                        <tr>
                            <th>Contact</th>
                            <th>Phone</th>
                            <th>Message</th>
                            <th>Status</th>
                            <th>Campaign</th>
                            <th>Parts</th>
                            <th>Cost</th>
                            <th>Date</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($logs as $log)
                            <tr>
                                <td>
                                    <div class="fw-bold">{{ $log->contact_name }}</div>
                                    @if($log->school_name)
                                        <small class="text-muted">{{ $log->school_name }}</small>
                                    @endif
                                </td>
                                <td>
                                    <span class="font-monospace">{{ $log->phone_number }}</span>
                                </td>
                                <td>
                                    <div class="message-content">
                                        {{ Str::limit($log->message_content, 100) }}
                                    </div>
                                    @if(strlen($log->message_content) > 100)
                                        <button class="btn btn-link btn-sm p-0" 
                                                onclick="showFullMessage('{{ $log->id }}', {{ json_encode($log->message_content) }})">
                                            Show Full Message
                                        </button>
                                    @endif
                                </td>
                                <td>
                                    <span class="badge status-{{ $log->status }}">
                                        @switch($log->status)
                                            @case('sent')
                                                <i class="fas fa-check"></i> Sent
                                                @break
                                            @case('failed')
                                                <i class="fas fa-times"></i> Failed
                                                @break
                                            @case('pending')
                                                <i class="fas fa-clock"></i> Pending
                                                @break
                                        @endswitch
                                    </span>
                                    @if($log->sent_at)
                                        <br><small class="text-muted">{{ $log->sent_at->format('H:i:s') }}</small>
                                    @endif
                                </td>
                                <td>
                                    @if($log->campaign_name)
                                        <span class="badge bg-secondary campaign-badge">
                                            {{ $log->campaign_name }}
                                        </span>
                                    @else
                                        <span class="text-muted">-</span>
                                    @endif
                                </td>
                                <td class="text-center">
                                    <span class="badge bg-info">{{ $log->parts }}</span>
                                </td>
                                <td>
                                    @if($log->cost)
                                        <span class="fw-bold text-success">KSH {{ number_format($log->cost, 2) }}</span>
                                    @else
                                        <span class="text-muted">-</span>
                                    @endif
                                </td>
                                <td>
                                    <div>{{ $log->created_at->format('M d, Y') }}</div>
                                    <small class="text-muted">{{ $log->created_at->format('H:i:s') }}</small>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="8" class="text-center py-5">
                                    <i class="fas fa-inbox fa-3x text-muted mb-3"></i>
                                    <h5 class="text-muted">No SMS logs found</h5>
                                    <p class="text-muted">
                                        @if($campaign || $status)
                                            Try adjusting your filters or 
                                            <a href="{{ route('sms.logs') }}">view all logs</a>
                                        @else
                                            Start by <a href="{{ route('sms.index') }}">sending your first SMS</a>
                                        @endif
                                    </p>
                                </td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>

        <!-- Summary -->
        <div class="text-center mt-3">
            <small class="text-muted">
                Showing {{ $logs->firstItem() ?? 0 }} to {{ $logs->lastItem() ?? 0 }} 
                of {{ $logs->total() }} total SMS logs
            </small>
        </div>
    </div>

    <!-- Full Message Modal -->
    <div class="modal fade" id="messageModal" tabindex="-1">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Full SMS Message</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <div id="fullMessageContent" class="p-3" style="background: #f8f9fa; border-radius: 8px; white-space: pre-wrap;"></div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                </div>
            </div>
        </div>
    </div>

    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
    <!-- jQuery -->
    <script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
    <!-- DataTables JS -->
    <script src="https://cdn.datatables.net/1.13.7/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/1.13.7/js/dataTables.bootstrap5.min.js"></script>
    <script src="https://cdn.datatables.net/responsive/2.5.0/js/dataTables.responsive.min.js"></script>
    <script src="https://cdn.datatables.net/responsive/2.5.0/js/responsive.bootstrap5.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.4.2/js/dataTables.buttons.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.4.2/js/buttons.bootstrap5.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.4.2/js/buttons.html5.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.4.2/js/buttons.print.min.js"></script>
    
    <script>
        $(document).ready(function() {
            // Initialize DataTable
            $('#smsLogsTable').DataTable({
                responsive: true,
                pageLength: {{ $perPage }},
                lengthMenu: [[25, 50, 100, 200], [25, 50, 100, 200]],
                order: [[7, 'desc']], // Sort by date descending
                language: {
                    search: "Search SMS logs:",
                    lengthMenu: "Show _MENU_ logs per page",
                    info: "Showing _START_ to _END_ of _TOTAL_ logs",
                    infoEmpty: "Showing 0 to 0 of 0 logs",
                    infoFiltered: "(filtered from _MAX_ total logs)",
                    paginate: {
                        first: "First",
                        last: "Last",
                        next: "Next",
                        previous: "Previous"
                    }
                },
                dom: '<"row"<"col-sm-12 col-md-6"l><"col-sm-12 col-md-6"f>>' +
                     '<"row"<"col-sm-12"tr>>' +
                     '<"row"<"col-sm-12 col-md-5"i><"col-sm-12 col-md-7"p>>',
                columnDefs: [
                    {
                        targets: [0], // Contact column
                        width: '150px'
                    },
                    {
                        targets: [1], // Phone column
                        width: '120px'
                    },
                    {
                        targets: [2], // Message column
                        width: '200px'
                    },
                    {
                        targets: [3], // Status column
                        width: '100px',
                        className: 'text-center'
                    },
                    {
                        targets: [4], // Campaign column
                        width: '120px'
                    },
                    {
                        targets: [5], // Parts column
                        width: '80px',
                        className: 'text-center'
                    },
                    {
                        targets: [6], // Cost column
                        width: '100px',
                        className: 'text-end'
                    },
                    {
                        targets: [7], // Date column
                        width: '120px',
                        className: 'text-center'
                    }
                ]
            });

            // Auto-submit filters on change
            document.getElementById('campaign').addEventListener('change', function() {
                document.getElementById('filter-form').submit();
            });

            document.getElementById('status').addEventListener('change', function() {
                document.getElementById('filter-form').submit();
            });

            document.getElementById('per_page').addEventListener('change', function() {
                document.getElementById('filter-form').submit();
            });
        });

        function showFullMessage(logId, message) {
            document.getElementById('fullMessageContent').textContent = message;
            const modal = new bootstrap.Modal(document.getElementById('messageModal'));
            modal.show();
        }
    </script>
</body>
</html> 