<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>SMS Manager - Send Messages to Contacts</title>
    <meta name="csrf-token" content="{{ csrf_token() }}">
    
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Font Awesome -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    @vite(['resources/css/app.css', 'resources/js/app.js'])
    
    <style>
        .sms-container {
            max-width: 1200px;
            margin: 0 auto;
            padding: 1.5rem;
        }
        
        .stats-card {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            border-radius: 10px;
            padding: 1.5rem;
            margin-bottom: 2rem;
        }
        
        .contact-card {
            border: 1px solid #dee2e6;
            border-radius: 8px;
            padding: 1rem;
            margin-bottom: 0.5rem;
            transition: all 0.3s ease;
            background: #fff;
        }
        
        .contact-card:hover {
            border-color: #6c04f5;
            box-shadow: 0 2px 8px rgba(108, 4, 245, 0.1);
        }
        
        .contact-card.selected {
            border-color: #6c04f5;
            background: #f8f9ff;
        }
        
        .btn-primary {
            background-color: #6c04f5;
            border-color: #6c04f5;
        }
        
        .btn-primary:hover {
            background-color: #5a03d1;
            border-color: #5a03d1;
        }
        
        .search-filters {
            background: #f8f9fa;
            border-radius: 10px;
            padding: 1.5rem;
            margin-bottom: 2rem;
        }
        
        .selected-count {
            font-weight: bold;
            color: #6c04f5;
        }
        
        .contact-checkbox {
            transform: scale(1.2);
        }
        
        .sticky-actions {
            position: sticky;
            top: 20px;
            z-index: 100;
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(10px);
            border-radius: 10px;
            padding: 1rem;
            margin-bottom: 1rem;
            border: 1px solid #dee2e6;
        }
        
        .school-badge {
            font-size: 0.7rem;
            padding: 0.25rem 0.5rem;
        }
        
        .pagination {
            --bs-pagination-padding-x: 0.75rem;
            --bs-pagination-padding-y: 0.375rem;
            --bs-pagination-font-size: 0.875rem;
            --bs-pagination-color: #6c04f5;
            --bs-pagination-bg: #fff;
            --bs-pagination-border-width: 1px;
            --bs-pagination-border-color: #dee2e6;
            --bs-pagination-border-radius: 0.375rem;
            --bs-pagination-hover-color: #5a03d1;
            --bs-pagination-hover-bg: #f8f9ff;
            --bs-pagination-hover-border-color: #6c04f5;
            --bs-pagination-focus-color: #5a03d1;
            --bs-pagination-focus-bg: #f8f9ff;
            --bs-pagination-focus-box-shadow: 0 0 0 0.25rem rgba(108, 4, 245, 0.25);
            --bs-pagination-active-color: #fff;
            --bs-pagination-active-bg: #6c04f5;
            --bs-pagination-active-border-color: #6c04f5;
            --bs-pagination-disabled-color: #6c757d;
            --bs-pagination-disabled-bg: #fff;
            --bs-pagination-disabled-border-color: #dee2e6;
        }
        
        .pagination .page-link {
            border-radius: 0.375rem !important;
            margin: 0 0.125rem;
        }

        .access-denied {
            opacity: 0.6;
            pointer-events: none;
        }
        
        .role-badge {
            position: absolute;
            top: 10px;
            right: 10px;
            font-size: 0.7rem;
        }
    </style>
</head>
<body class="bg-light">
    <div class="mainn">
       <div class="mt-0">
            @include('layouts.navigation')
        </div>
        
        <!-- Header -->
        <div class="container sms-container">
            <!-- Access Control Check -->
            @can('access-messages')
                <!-- SMS Stats -->
                <div class="stats-card">
                    <div class="text-center row">
                        <div class="col-6 col-md-3">
                            <h4><i class="fas fa-paper-plane"></i> {{ number_format($smsStats['total_contacts']) }}</h4>
                            <p class="mb-0">No of contacts</p>
                        </div>
                        <div class="col-6 col-md-3">
                            <h4><i class="fas fa-exclamation-triangle"></i> {{ number_format($smsStats['total_sent']) }}</h4>
                            <p class="mb-0">sent</p>
                        </div>
                        <div class="col-6 col-md-3">
                            <h4><i class="fas fa-clock"></i> {{ number_format($smsStats['total_pending']) }}</h4>
                            <p class="mb-0">Pending</p>
                        </div>
                        <div class="col-6 col-md-3">
                            <h4><i class="fas fa-money-bill"></i> KSH {{ number_format($smsStats['total_cost'], 2) }}</h4>
                            <p class="mb-0">Total Cost</p>
                        </div>
                    </div>
                </div>

                <!-- Messages -->
                @if (session('success'))
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        <i class="fas fa-check-circle"></i>
                        {!! session('success') !!}
                        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                    </div>
                @endif

                @if (session('error'))
                    <div class="alert alert-danger alert-dismissible fade show" role="alert">
                        <i class="fas fa-exclamation-circle"></i>
                        {{ session('error') }}
                        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                    </div>
                @endif

                <!-- Navigation Buttons with Role-Based Access -->
                <div class="mb-4 shadow-sm card w-100">
                    <div class="card-body">
                        <div class="flex-wrap gap-3 d-flex justify-content-evenly align-items-center">
                            <!-- All Tickets - Accessible to all roles with view-tickets permission -->
                            {{-- @can('view-tickets')
                                <a href="{{ route('tickets.index') }}" class="btn btn-primary">
                                    <i class="fas fa-list"></i> All Tickets
                                </a>
                            @endcan --}}
                            
                            <!-- Analytics - Only for super-admin and management -->
                            {{-- @can('view-metrics')
                                <a href="{{ route('tickets.analytics') }}" class="btn btn-outline-primary">
                                    <i class="fas fa-chart-bar"></i> Analytics
                                </a>
                            @endcan --}}
                            
                            <!-- SMS Manager - Current page, already protected -->
                            {{-- <a href="{{ route('sms.index') }}" class="btn btn-outline-secondary">
                                <i class="fas fa-sms"></i> SMS Manager
                            </a> --}}
                            
                            <!-- Add Contacts - Only for super-admin and customer-support -->
                            @can('manage-contacts')
                                <a href="{{ url('admin/contacts/import') }}" class="btn btn-outline-success">
                                    <i class="fas fa-user-plus"></i> Add New Contacts
                                </a>
                            @endcan
                            
                            <!-- Complimentary Tickets - Only for super-admin -->
                            {{-- @can('access-complimentary')
                                <a href="{{ route('complimentary.tickets.index') }}" class="btn btn-outline-dark">
                                    <i class="fas fa-home"></i> Manage Complimentary tickets
                                </a>
                            @endcan --}}
                        </div>
                    </div>
                </div>

                <!-- Search and Filters -->
                <div class="search-filters">
                    <form method="GET" action="{{ route('sms.index') }}" id="filter-form">
                        <div class="row align-items-end">
                            <div class="col-md-4">
                                <label for="search" class="form-label">Search Contacts</label>
                                <input type="text" class="form-control" id="search" name="search" 
                                    value="{{ $search }}" placeholder="Name, phone, or social media">
                            </div>
                            <div class="col-md-3">
                                <label for="school" class="form-label">Filter by School</label>
                                <select class="form-select" id="school" name="school">
                                    <option value="">All Schools</option>
                                    @foreach($schools as $schoolName)
                                        <option value="{{ $schoolName }}" {{ $school === $schoolName ? 'selected' : '' }}>
                                            {{ $schoolName }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="col-md-2">
                                <label for="per_page" class="form-label">Per Page</label>
                                <select class="form-select" id="per_page" name="per_page">
                                    <option value="25" {{ $perPage == 25 ? 'selected' : '' }}>25</option>
                                    <option value="50" {{ $perPage == 50 ? 'selected' : '' }}>50</option>
                                    <option value="100" {{ $perPage == 100 ? 'selected' : '' }}>100</option>
                                    <option value="200" {{ $perPage == 200 ? 'selected' : '' }}>200</option>
                                </select>
                            </div>
                            <div class="col-md-3">
                                <button type="submit" class="btn btn-outline-primary me-2">
                                    <i class="fas fa-search"></i> Filter
                                </button>
                                <a href="{{ route('sms.index') }}" class="btn btn-outline-secondary">
                                    <i class="fas fa-times"></i> Clear
                                </a>
                            </div>
                        </div>
                    </form>
                </div>

                <!-- Sticky Actions Bar -->
                <div class="sticky-actions">
                    <div class="row align-items-center">
                        <div class="col-md-6">
                            <div class="form-check">
                                <input class="form-check-input contact-checkbox" type="checkbox" id="select-all">
                                <label class="form-check-label fw-bold" for="select-all">
                                    Select All Results
                                </label>
                            </div>
                            <small class="text-muted">
                                <span class="selected-count" id="selected-count">0</span> contacts selected
                            </small>
                        </div>
                        <div class="col-md-6 text-end">
                            <button type="button" class="btn btn-success btn-lg" id="send-sms-btn" disabled onclick="composeSms()">
                                <i class="fas fa-paper-plane"></i> Send SMS to Selected
                            </button>
                        </div>
                    </div>
                </div>

                <!-- Contacts List -->
                <div class="row">
                    @forelse($contacts as $contact)
                        <div class="col-lg-6 col-xl-4">
                            <div class="contact-card" data-contact-id="{{ $contact->id }}">
                                <div class="row align-items-center">
                                    <div class="col-2">
                                        <input class="form-check-input contact-checkbox contact-select" 
                                            type="checkbox" 
                                            value="{{ $contact->id }}" 
                                            id="contact-{{ $contact->id }}">
                                    </div>
                                    <div class="col-10">
                                        <div class="d-flex justify-content-between align-items-start">
                                            <div class="flex-grow-1">
                                                <h6 class="mb-1 fw-bold">{{ $contact->name }}</h6>
                                                <p class="mb-1 text-muted">
                                                    <i class="fas fa-phone text-primary"></i>
                                                    {{ $contact->phone_no }}
                                                </p>
                                                @if($contact->socials)
                                                    <p class="mb-1 text-muted small">
                                                        <i class="fas fa-at text-info"></i>
                                                        {{ $contact->socials }}
                                                    </p>
                                                @endif
                                                @if($contact->school_name)
                                                    <span class="badge bg-secondary school-badge">
                                                        {{ $contact->school_name }}
                                                    </span>
                                                @endif
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    @empty
                        <div class="col-12">
                            <div class="py-5 text-center">
                                <i class="mb-3 fas fa-users fa-3x text-muted"></i>
                                <h4 class="text-muted">No contacts found</h4>
                                <p class="text-muted">Try adjusting your search filters or 
                                    @can('manage-contacts')
                                        <a href="{{ route('contacts.import.form') }}">import contacts</a>
                                    @else
                                        contact an administrator to import contacts
                                    @endcan
                                </p>
                            </div>
                        </div>
                    @endforelse
                </div>

                <!-- Pagination -->
                @if($contacts->hasPages())
                    <div class="mt-4 d-flex justify-content-center">
                        <nav aria-label="Contacts pagination">
                            {{ $contacts->links('pagination::bootstrap-4') }}
                        </nav>
                    </div>
                @endif

                <!-- Contact Summary -->
                <div class="mt-3 text-center">
                    <small class="text-muted">
                        Showing {{ $contacts->firstItem() ?? 0 }} to {{ $contacts->lastItem() ?? 0 }} 
                        of {{ $contacts->total() }} total contacts
                    </small>
                </div>

                <!-- SMS Compose Form (Hidden) -->
                <form id="compose-form" method="POST" action="{{ route('sms.compose') }}" style="display: none;">
                    @csrf
                    <div id="selected-contacts-input"></div>
                </form>

            @else
                <!-- Access Denied Message -->
                <div class="access-denied">
                    <div class="py-5 text-center">
                        <i class="mb-3 fas fa-ban fa-4x text-danger"></i>
                        <h2 class="text-danger">Access Denied</h2>
                        <p class="text-muted">You don't have permission to access the SMS Manager.</p>
                        <div class="mt-4">
                            @can('view-tickets')
                                <a href="{{ route('tickets.index') }}" class="btn btn-primary">
                                    <i class="fas fa-list"></i> Go to Tickets
                                </a>
                            @endcan
                            @can('view-metrics')
                                <a href="{{ route('tickets.analytics') }}" class="btn btn-outline-primary ms-2">
                                    <i class="fas fa-chart-bar"></i> View Analytics
                                </a>
                            @endcan
                        </div>
                        <div class="mt-3">
                            <small class="text-muted">
                                Required permission: <code>access-messages</code><br>
                                Your role: <strong>{{ Auth::user()->getRoleNames()->first() ?? 'No role assigned' }}</strong>
                            </small>
                        </div>
                    </div>
                </div>
            @endcan

        </div>
    </div>

    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
    
    <script>
        // Global variables for all contacts selection
        window.allContactsSelected = false;
        window.allSelectedContactIds = [];
        
        document.addEventListener('DOMContentLoaded', function() {
            // Only initialize SMS functionality if user has access
            @can('access-messages')
                const selectAllCheckbox = document.getElementById('select-all');
                const contactCheckboxes = document.querySelectorAll('.contact-select');
                const selectedCountSpan = document.getElementById('selected-count');
                const sendSmsBtn = document.getElementById('send-sms-btn');
                const contactCards = document.querySelectorAll('.contact-card');

                // Update selected count and button state
                function updateSelection() {
                    // If all contacts are selected from database, don't update the count
                    if (window.allContactsSelected) {
                        return;
                    }
                    
                    const selectedContacts = document.querySelectorAll('.contact-select:checked');
                    const count = selectedContacts.length;
                    
                    selectedCountSpan.textContent = count;
                    sendSmsBtn.disabled = count === 0;
                    
                    // Update select all checkbox state
                    if (selectAllCheckbox) {
                        selectAllCheckbox.indeterminate = count > 0 && count < contactCheckboxes.length;
                        selectAllCheckbox.checked = count === contactCheckboxes.length && count > 0;
                    }
                    
                    // Update contact card styles
                    contactCards.forEach(card => {
                        const checkbox = card.querySelector('.contact-select');
                        if (checkbox && checkbox.checked) {
                            card.classList.add('selected');
                        } else {
                            card.classList.remove('selected');
                        }
                    });
                }

                // Select all functionality
                if (selectAllCheckbox) {
                    selectAllCheckbox.addEventListener('change', function() {
                        if (this.checked) {
                            // Select all contacts from filtered results
                            selectAllContactsFromDatabase();
                        } else {
                            // Unselect all contacts on current page
                            contactCheckboxes.forEach(checkbox => {
                                checkbox.checked = false;
                            });
                            // Clear any stored all contacts selection
                            window.allContactsSelected = false;
                            window.allSelectedContactIds = [];
                            updateSelection();
                        }
                    });
                }

                // Function to select all contacts from filtered results
                function selectAllContactsFromDatabase() {
                    const currentUrl = new URL(window.location);
                    const params = new URLSearchParams({
                        search: currentUrl.searchParams.get('search') || '',
                        school: currentUrl.searchParams.get('school') || ''
                    });

                    fetch(`{{ route('sms.all-contact-ids') }}?${params}`)
                        .then(response => response.json())
                        .then(data => {
                            window.allContactsSelected = true;
                            window.allSelectedContactIds = data.contact_ids;
                            
                            // Check all visible checkboxes
                            contactCheckboxes.forEach(checkbox => {
                                checkbox.checked = true;
                            });
                            
                            // Update the count to show total from filtered results
                            selectedCountSpan.textContent = data.total_count;
                            sendSmsBtn.disabled = false;
                            
                            // Update contact card styles
                            contactCards.forEach(card => {
                                card.classList.add('selected');
                            });
                        })
                        .catch(error => {
                            console.error('Error fetching all contact IDs:', error);
                            alert('Error selecting all contacts. Please try again.');
                            if (selectAllCheckbox) {
                                selectAllCheckbox.checked = false;
                            }
                        });
                }

                // Individual contact selection
                contactCheckboxes.forEach(checkbox => {
                    checkbox.addEventListener('change', function() {
                        // If all contacts were selected and user unchecks one, switch to individual selection mode
                        if (window.allContactsSelected && !this.checked) {
                            window.allContactsSelected = false;
                            window.allSelectedContactIds = [];
                            if (selectAllCheckbox) {
                                selectAllCheckbox.checked = false;
                            }
                        }
                        updateSelection();
                    });
                });

                // Click on contact card to toggle selection
                contactCards.forEach(card => {
                    card.addEventListener('click', function(e) {
                        if (e.target.type !== 'checkbox') {
                            const checkbox = this.querySelector('.contact-select');
                            if (checkbox) {
                                checkbox.checked = !checkbox.checked;
                                updateSelection();
                            }
                        }
                    });
                });

                // Auto-submit filters on change
                const schoolFilter = document.getElementById('school');
                const perPageFilter = document.getElementById('per_page');
                
                if (schoolFilter) {
                    schoolFilter.addEventListener('change', function() {
                        document.getElementById('filter-form').submit();
                    });
                }
                
                if (perPageFilter) {
                    perPageFilter.addEventListener('change', function() {
                        document.getElementById('filter-form').submit();
                    });
                }

                // Initialize
                updateSelection();
            @endcan
        });

        function composeSms() {
            @can('access-messages')
                let contactIds = [];
                
                // Check if all contacts are selected from filtered results
                if (window.allContactsSelected && window.allSelectedContactIds.length > 0) {
                    contactIds = window.allSelectedContactIds;
                } else {
                    // Get selected contacts from current page
                    const selectedContacts = document.querySelectorAll('.contact-select:checked');
                    
                    if (selectedContacts.length === 0) {
                        alert('Please select at least one contact to send SMS.');
                        return;
                    }
                    
                    contactIds = Array.from(selectedContacts).map(checkbox => checkbox.value);
                }
                
                if (contactIds.length === 0) {
                    alert('Please select at least one contact to send SMS.');
                    return;
                }

                // Add selected contact IDs to the form
                const inputContainer = document.getElementById('selected-contacts-input');
                inputContainer.innerHTML = '';

                contactIds.forEach(contactId => {
                    const input = document.createElement('input');
                    input.type = 'hidden';
                    input.name = 'selected_contacts[]';
                    input.value = contactId;
                    inputContainer.appendChild(input);
                });

                // Submit the form
                document.getElementById('compose-form').submit();
            @else
                alert('Access denied: You do not have permission to send SMS messages.');
            @endcan
        }
    </script>
</body>
</html>