<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Edit Message Template - PaceEvents</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    @vite(['resources/css/app.css', 'resources/js/app.js'])
    <style>
        .template-container {
            max-width: 800px;
            margin: 0 auto;
            padding: 20px;
        }
        .btn-primary {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            border: none;
        }
        .btn-primary:hover {
            background: linear-gradient(135deg, #5a6fd8 0%, #6a4190 100%);
        }
        .form-control:focus {
            border-color: #667eea;
            box-shadow: 0 0 0 0.2rem rgba(102, 126, 234, 0.25);
        }
        .char-counter {
            font-size: 0.875rem;
            color: #6c757d;
        }
    </style>
</head>
<body>
    <div class="template-container">
        <!-- Header -->
        <div class="mb-4">
            <h1 class="h3 mb-1"><i class="fas fa-edit text-primary"></i> Edit Message Template</h1>
            <p class="text-muted">Update your SMS message template</p>
        </div>

        <!-- Error Messages -->
        @if($errors->any())
            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                <h6><i class="fas fa-exclamation-circle"></i> Please fix the following errors:</h6>
                <ul class="mb-0">
                    @foreach($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
        @endif

        <!-- Form -->
        <div class="card">
            <div class="card-body">
                <form action="{{ route('admin.message-templates.update', $messageTemplate) }}" method="POST">
                    @csrf
                    @method('PUT')
                    
                    <div class="mb-3">
                        <label for="name" class="form-label">Template Name <span class="text-danger">*</span></label>
                        <input type="text" class="form-control" id="name" name="name" 
                               value="{{ old('name', $messageTemplate->name) }}" required 
                               placeholder="e.g., Event Reminder, Welcome Message">
                        <div class="form-text">Give your template a descriptive name</div>
                    </div>

                    <div class="mb-3">
                        <label for="description" class="form-label">Description</label>
                        <input type="text" class="form-control" id="description" name="description" 
                               value="{{ old('description', $messageTemplate->description) }}" 
                               placeholder="Brief description of when to use this template">
                        <div class="form-text">Optional: Describe when this template should be used</div>
                    </div>

                    <div class="mb-3">
                        <label for="content" class="form-label">Message Content <span class="text-danger">*</span></label>
                        
                        <!-- Available Placeholders -->
                        <div class="card mb-3" style="background-color: #f8f9fa;">
                            <div class="card-body py-2">
                                <h6 class="card-title mb-2" style="font-size: 0.9rem;"><i class="fas fa-tags text-primary"></i> Available Placeholders</h6>
                                <div class="d-flex flex-wrap gap-2">
                                    <button type="button" class="btn btn-outline-primary btn-sm" onclick="insertPlaceholder('{first-name}')" title="Insert first name only">
                                        <i class="fas fa-user"></i> First Name
                                    </button>
                                    <button type="button" class="btn btn-outline-primary btn-sm" onclick="insertPlaceholder('{name}')" title="Insert full name">
                                        <i class="fas fa-id-card"></i> Full Name
                                    </button>
                                    <button type="button" class="btn btn-outline-primary btn-sm" onclick="insertPlaceholder('{school}')" title="Insert school name">
                                        <i class="fas fa-school"></i> School
                                    </button>
                                    <button type="button" class="btn btn-outline-primary btn-sm" onclick="insertPlaceholder('{event-name}')" title="Insert event name">
                                        <i class="fas fa-calendar-alt"></i> Event Name
                                    </button>
                                    <button type="button" class="btn btn-outline-primary btn-sm" onclick="insertPlaceholder('{event-date}')" title="Insert event date">
                                        <i class="fas fa-calendar"></i> Event Date
                                    </button>
                                    <button type="button" class="btn btn-outline-primary btn-sm" onclick="insertPlaceholder('{ticket-type}')" title="Insert ticket type">
                                        <i class="fas fa-ticket-alt"></i> Ticket Type
                                    </button>
                                </div>
                                <div class="mt-2">
                                    <small class="text-muted"><i class="fas fa-info-circle"></i> Click any button above to add it to your message. These will be replaced with actual values when sending.</small>
                                </div>
                            </div>
                        </div>
                        
                        <textarea class="form-control" id="content" name="content" rows="6" required 
                                  placeholder="Enter your message content here..." 
                                  onkeyup="updateCharCount()">{{ old('content', $messageTemplate->content) }}</textarea>
                        <div class="d-flex justify-content-between">
                            <div class="form-text">Write your SMS message content using the placeholders above</div>
                            <div class="char-counter">
                                <span id="charCount">0</span>/160 characters
                            </div>
                        </div>
                    </div>

                    <div class="mb-4">
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" id="is_active" name="is_active" value="1"
                                   {{ old('is_active', $messageTemplate->is_active) ? 'checked' : '' }}>
                            <label class="form-check-label" for="is_active">
                                Active Template
                            </label>
                            <div class="form-text">Only active templates will be available for selection</div>
                        </div>
                    </div>

                    <div class="d-flex justify-content-between">
                        <a href="{{ route('admin.message-templates.index') }}" class="btn btn-outline-secondary">
                            <i class="fas fa-arrow-left"></i> Cancel
                        </a>
                        <div>
                            <a href="{{ route('admin.message-templates.show', $messageTemplate) }}" class="btn btn-outline-info me-2">
                                <i class="fas fa-eye"></i> Preview
                            </a>
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-save"></i> Update Template
                            </button>
                        </div>
                    </div>
                </form>
            </div>
        </div>

        <!-- Template Info -->
        <div class="card mt-4">
            <div class="card-body">
                <h6 class="card-title"><i class="fas fa-info-circle text-info"></i> Template Information</h6>
                <div class="row">
                    <div class="col-md-6">
                        <small class="text-muted">Created:</small><br>
                        <span class="small">{{ $messageTemplate->created_at->format('M d, Y \\a\\t g:i A') }}</span>
                    </div>
                    <div class="col-md-6">
                        <small class="text-muted">Last Updated:</small><br>
                        <span class="small">{{ $messageTemplate->updated_at->format('M d, Y \\a\\t g:i A') }}</span>
                    </div>
                </div>
            </div>
        </div>

        <!-- Tips -->
        <div class="card mt-4">
            <div class="card-body">
                <h6 class="card-title"><i class="fas fa-lightbulb text-warning"></i> Tips for Editing Templates</h6>
                <ul class="mb-0 small">
                    <li>Keep messages under 160 characters for single SMS</li>
                    <li>Use clear and concise language</li>
                    <li>Include relevant information like event details, dates, or contact info</li>
                    <li>Test your templates before using them in campaigns</li>
                    <li>Deactivate templates that are no longer needed instead of deleting them</li>
                </ul>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        function updateCharCount() {
            const content = document.getElementById('content').value;
            const charCount = content.length;
            const counter = document.getElementById('charCount');
            
            counter.textContent = charCount;
            
            // Change color based on character count
            if (charCount > 160) {
                counter.style.color = '#dc3545'; // Red
            } else if (charCount > 140) {
                counter.style.color = '#fd7e14'; // Orange
            } else {
                counter.style.color = '#6c757d'; // Gray
            }
        }
        
        function insertPlaceholder(placeholder) {
            const textarea = document.getElementById('content');
            const start = textarea.selectionStart;
            const end = textarea.selectionEnd;
            const text = textarea.value;
            
            // Insert the placeholder at cursor position
            const newText = text.substring(0, start) + placeholder + text.substring(end);
            textarea.value = newText;
            
            // Move cursor to end of inserted placeholder
            const newCursorPos = start + placeholder.length;
            textarea.setSelectionRange(newCursorPos, newCursorPos);
            
            // Focus back to textarea
            textarea.focus();
            
            // Update character count
            updateCharCount();
        }
        
        // Initialize character count on page load
        document.addEventListener('DOMContentLoaded', function() {
            updateCharCount();
        });
    </script>
</body>
</html>