<x-app-layout>
    {{-- <x-slot name="header">
        <div class="mb-4 shadow-sm card w-100">
            <div class="card-body">
                <!-- Second Row: Buttons -->
                <div class="flex-wrap gap-3 d-flex justify-content-evenly align-items-center">
                    <a href="{{ route('users.index') }}" class="btn btn-primary @can('view-users') active @endcan">
                        <i class="fas fa-users"></i> Users
                    </a>
                    
                    <a href="{{ route('tickets.index') }}" class="btn btn-primary">
                        <i class="fas fa-list"></i> All Tickets
                    </a>
                    
                    @can('view-metrics')
                    <a href="{{ route('tickets.analytics') }}" class="btn btn-outline-primary">
                        <i class="fas fa-chart-bar"></i> Analytics
                    </a>
                    @endcan
                    
                    @can('access-messages')
                    <a href="{{ route('sms.index') }}" class="btn btn-outline-secondary">
                        <i class="fas fa-sms"></i> SMS Manager
                    </a>
                    @endcan
                    
                    @can('access-complimentary')
                    <a href="{{ route('complimentary.tickets.index') }}" class="btn btn-outline-dark">
                        <i class="fas fa-home"></i> Manage Complimentary tickets
                    </a>
                    @endcan
                    
                    @can('manage-contacts')
                    <a href="{{ route('contacts.import.form') }}" class="btn btn-outline-info">
                        <i class="fas fa-users"></i> Manage Contacts
                    </a>
                    @endcan
                </div>
            </div>
        </div>
    </x-slot> --}}

   <div class="container-fluid tickets-container">
        <!-- Messages -->
        @if (session('success'))
            <div class="alert alert-success alert-dismissible fade show" role="alert">
                <i class="fas fa-check-circle"></i>
                {!! session('success') !!}
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
        @endif

        @if (session('error'))
            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                <i class="fas fa-exclamation-circle"></i>
                {{ session('error') }}
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
        @endif
        
        <!-- Ticket Stats -->
        <div class="row stats-row">
            @can('view-metrics')
            <div class="mb-3 col-md-3 col-sm-6 stats-col">
                <div class="stats-card success">
                    <div class="text-center">
                        <h4><i class="fas fa-ticket-alt"></i> {{ number_format($ticketStats['total_tickets']) }}</h4>
                        <p class="mb-0">Total Tickets</p>
                    </div>
                </div>
            </div>
            @endcan
            <div class="mb-3 col-md-3 col-sm-6 stats-col">
                <div class="stats-card info">
                    <div class="text-center">
                        <h4><i class="fas fa-check-circle"></i> {{ number_format($ticketStats['total_paid']) }}</h4>
                        <p class="mb-0">Paid Tickets</p>
                    </div>
                </div>
            </div>
            <div class="mb-3 col-md-3 col-sm-6 stats-col">
                <div class="stats-card warning">
                    <div class="text-center">
                        <h4><i class="fas fa-clock"></i> {{ number_format($ticketStats['total_pending']) }}</h4>
                        <p class="mb-0">Pending</p>
                    </div>
                </div>
            </div>
            <div class="mb-3 col-md-3 col-sm-6 stats-col">
                <div class="stats-card danger">
                    <div class="text-center">
                        <h4><i class="fas fa-times-circle"></i> {{ number_format($ticketStats['total_failed']) }}</h4>
                        <p class="mb-0">Failed</p>
                    </div>
                </div>
            </div>
        </div>

        <!-- Revenue Stats - Only show for users with view-metrics permission -->
        @can('view-metrics')
        <div class="row stats-row">
            <div class="mb-3 col-md-3 col-sm-6 stats-col">
                <div class="stats-card">
                    <div class="text-center">
                        <h4><i class="fas fa-money-bill-wave"></i> KSH {{ number_format($ticketStats['total_revenue'], 2) }}</h4>
                        <p class="mb-0">Total Revenue</p> 
                    </div>
                </div>
            </div>
            <div class="mb-3 col-md-3 col-sm-6 stats-col">
                <div class="stats-card success">
                    <div class="text-center">
                        <h4><i class="fas fa-calendar-day"></i> {{ number_format($ticketStats['today_sales']) }}</h4>
                        <p class="mb-0">Today's Sales</p>
                    </div>
                </div>
            </div>
            <div class="mb-3 col-md-3 col-sm-6 stats-col">
                <div class="stats-card info">
                    <div class="text-center">
                        <h4><i class="fas fa-money-bill"></i> KSH {{ number_format($ticketStats['today_revenue'], 2) }}</h4>
                        <p class="mb-0">Today's Revenue</p>
                    </div>
                </div>
            </div>
            <div class="mb-3 col-md-3 col-sm-6 stats-col">
                <div class="stats-card warning">
                    <div class="text-center">
                        <h4><i class="fas fa-calendar-alt"></i> {{ number_format($ticketStats['this_month_sales']) }}</h4>
                        <p class="mb-0">This Month</p>
                    </div>
                </div>
            </div>
        </div>
        @else
        @endcan

        <!-- Search and Filters -->
        <div class="search-filters">
            <form method="GET" action="{{ route('tickets.index') }}" id="filter-form">
                <div class="row align-items-end">
                    <div class="col-md-3">
                        <label for="search" class="form-label">Search Tickets</label>
                        <input type="text" class="form-control" id="search" name="search" 
                               value="{{ $search }}" placeholder="Name, phone, email, school, or reference">
                    </div>
                    <div class="col-md-2">
                        <label for="status" class="form-label">Status</label>
                        <select class="form-select" id="status" name="status">
                            <option value="">All Status</option>
                            <option value="completed" {{ $status === 'completed' ? 'selected' : '' }}>Completed</option>
                            <option value="pending" {{ $status === 'pending' ? 'selected' : '' }}>Pending</option>
                            <option value="failed" {{ $status === 'failed' ? 'selected' : '' }}>Failed</option>
                        </select>
                    </div>
                    {{-- <div class="col-md-2">
                        <label for="event" class="form-label">Event</label>
                        <select class="form-select" id="event" name="event">
                            <option value="">All Events</option>
                            @foreach($events as $eventItem)
                                <option value="{{ $eventItem->id }}" {{ $event == $eventItem->id ? 'selected' : '' }}>
                                    {{ $eventItem->name }}
                                </option>
                            @endforeach
                        </select>
                    </div> --}}
                    <div class="col-md-2">
                        <label for="school" class="form-label">School</label>
                        <select class="form-select" id="school" name="school">
                            <option value="">All Schools</option>
                            @foreach($schools as $schoolName)
                                <option value="{{ $schoolName }}" {{ $school === $schoolName ? 'selected' : '' }}>
                                    {{ $schoolName }}
                                </option>
                            @endforeach
                        </select>
                    </div>
                    <div class="col-md-2">
                        <label for="stk_status" class="form-label">STK Status</label>
                        <select class="form-select" id="stk_status" name="stk_status">
                            <option value="">All STK Status</option>
                            <option value="Success" {{ $stkStatus === 'Success' ? 'selected' : '' }}>Success</option>
                            <option value="Launched" {{ $stkStatus === 'Launched' ? 'selected' : '' }}>Launched</option>
                            <option value="Failed" {{ $stkStatus === 'Failed' ? 'selected' : '' }}>Failed</option>
                            <option value="Canceled" {{ $stkStatus === 'Canceled' ? 'selected' : '' }}>Canceled</option>
                            <option value="Timeout" {{ $stkStatus === 'Timeout' ? 'selected' : '' }}>Timeout</option>
                            <option value="Invalid-user-input" {{ $stkStatus === 'Invalid-user-input' ? 'selected' : '' }}>Invalid User Input</option>
                            <option value="insufficient-funds" {{ $stkStatus === 'insufficient-funds' ? 'selected' : '' }}>Insufficient Funds</option>
                            <option value="User-cannot-be-reached" {{ $stkStatus === 'User-cannot-be-reached' ? 'selected' : '' }}>User Cannot be Reached</option>
                            <option value="No-response-from-user" {{ $stkStatus === 'No-response-from-user' ? 'selected' : '' }}>No Response from User</option>
                        </select>
                    </div>
                    <div class="col-md-1">
                        <label for="per_page" class="form-label">Per Page</label>
                        <select class="form-select" id="per_page" name="per_page">
                            <option value="25" {{ $perPage == 25 ? 'selected' : '' }}>25</option>
                            <option value="50" {{ $perPage == 50 ? 'selected' : '' }}>50</option>
                            <option value="100" {{ $perPage == 100 ? 'selected' : '' }}>100</option>
                            <option value="200" {{ $perPage == 200 ? 'selected' : '' }}>200</option>
                        </select>
                    </div>
                    <div class="col-md-1">
                        <button type="submit" class="btn btn-outline-primary">
                            <i class="fas fa-search"></i>
                        </button>
                    </div>
                </div>
                <div class="mt-2 row">
                    <div class="col-md-12">
                        <a href="{{ route('tickets.index') }}" class="btn btn-outline-secondary btn-sm">
                            <i class="fas fa-times"></i> Clear Filters
                        </a>
                        <a href="{{ route('tickets.export') }}?{{ http_build_query(request()->all()) }}" class="btn btn-outline-success btn-sm">
                            <i class="fas fa-download"></i> Export CSV
                        </a>
                    </div>
                </div>
            </form>
        </div>

        <!-- Tickets Table -->
        <div class="table-responsive-container">
            <table class="table table-hover" id="ticketsTable">
                <thead>
                    <tr>
                        <th>ID</th>
                        <th>Reference</th>
                        <th>Customer</th>
                        <th>Contact</th>
                        <th>School</th>
                        <th>Qty</th>
                        <th>Amount</th>
                        <th>Status</th>
                        <th>STK Status</th>
                        <th>Payment Date</th>
                        <th>Created</th>
                    </tr>
                </thead>
                <tbody>
                    @php $checkDuplicate = []; $count = 1; @endphp
                    @forelse($tickets as $ticket)
                        <tr>
                            <td>{{ $count++ }}</td>
                            <td>
                                <span class="ticket-reference">{{ $ticket->reference }}</span>
                            </td>
                            <td>
                                <strong>{{ $ticket->first_name }} {{ $ticket->last_name }}</strong>
                            </td>
                            <td>
                                <div class="scrollable-contact">
                                    <div>
                                        <i class="fas fa-phone text-primary"></i> {{ $ticket->phone }}<br>
                                        <i class="fas fa-envelope text-info"></i> {{ $ticket->email }}
                                    </div>
                                </div>
                            </td>
                            <td>
                                @if($ticket->school)
                                    <span class="badge bg-secondary school-badge">{{ $ticket->school }}</span>
                                @else
                                    <span class="text-muted">-</span>
                                @endif
                            </td>
                            <td class="text-center">
                                <span class="badge bg-info">{{ $ticket->quantity }}</span>
                            </td>
                            <td>
                                <div class="amount-display">
                                    KSH {{ number_format($ticket->total_amount, 2) }}
                                </div>
                                <small class="text-muted">@ KSH {{ number_format($ticket->amount, 2) }}/ticket</small>
                            </td>
                            <td>
                                @if($ticket->payment_status === 'completed')
                                    <span class="badge status-badge badge-success status-completed">
                                        <i class="fas fa-check"></i> Paid
                                    </span>
                                    @if($ticket->mpesa_receipt_number)
                                        <br><small class="text-muted">{{ $ticket->mpesa_receipt_number }}</small>
                                    @endif
                                @elseif($ticket->payment_status === 'pending')
                                    <span class="badge status-badge bg-warning text-dark status-pending">
                                        <i class="fas fa-clock"></i> Pending
                                    </span>
                                @else
                                    <span class="bg-white badge status-badge text-danger status-failed">
                                        <i class="fas fa-times"></i> Failed
                                    </span>
                                @endif
                            </td>
                            <td>
                                @if($ticket->stk_status)
                                    @if($ticket->stk_status === 'Success')
                                        <span class="text-white badge status-badge bg-success stk-status-success">
                                            <i class="fas fa-check"></i> Success
                                        </span>
                                    @elseif($ticket->stk_status === 'Launched')
                                        <span class="text-white badge status-badge bg-success stk-status-pending">
                                            <i class="fas fa-clock"></i> Launched
                                        </span>
                                    @elseif($ticket->stk_status === 'Failed')
                                        <span class="text-white badge status-badge bg-danger stk-status-failed">
                                            <i class="fas fa-times"></i> Failed
                                        </span>
                                    @elseif($ticket->stk_status === 'Canceled')
                                        <span class="text-white badge status-badge bg-info stk-status-canceled">
                                            <i class="fas fa-ban"></i> Canceled
                                        </span>
                                    @elseif($ticket->stk_status === 'Timeout')
                                        <span class="text-white badge status-badge bg-danger stk-status-timeout">
                                            <i class="fas fa-clock"></i> Timeout
                                        </span>
                                    @elseif($ticket->stk_status === 'insufficient-funds')
                                        <span class="badge status-badge stk-status-insufficient">
                                            <i class="fas fa-wallet"></i> Insufficient
                                        </span>
                                    @elseif($ticket->stk_status === 'User-cannot-be-reached')
                                        <span class="badge status-badge bg-secondary" style="background:#424242;color:#fff;">
                                            <i class="fas fa-user-times"></i> No Contact
                                        </span>
                                    @elseif($ticket->stk_status === 'No-response-from-user')
                                        <span class="badge status-badge bg-secondary" style="background:#424242;color:#fff;">
                                            <i class="fas fa-user-times"></i> No Response
                                        </span>
                                    @elseif($ticket->stk_status === 'Invalid-user-input')
                                        <span class="text-white badge status-badge bg-info stk-status-invalid-input">
                                            <i class="fas fa-exclamation-triangle"></i> Invalid Input
                                        </span>
                                    @else
                                        <span class="badge bg-info status-badge">
                                            {{ ucfirst($ticket->stk_status) }}
                                        </span>
                                    @endif
                                @else
                                    <span class="text-muted">-</span>
                                @endif
                            </td>
                            <td>
                                <div class="scrollable-payment-date">
                                    @if($ticket->payment_date && $ticket->payment_date instanceof \Carbon\Carbon)
                                        {{ $ticket->payment_date->format('d/m/Y H:i') }}
                                    @elseif($ticket->payment_date)
                                        {{ \Carbon\Carbon::parse($ticket->payment_date)->format('d/m/Y H:i') }}
                                    @else
                                        <span class="text-muted">-</span>
                                    @endif
                                </div>
                            </td>
                            <td>
                                {{ $ticket->created_at ? $ticket->created_at->format('d/m/Y H:i') : '-' }}
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="11" class="py-5 text-center">
                                <i class="mb-3 fas fa-ticket-alt fa-3x text-muted"></i>
                                <h4 class="text-muted">No tickets found</h4>
                                <p class="text-muted">Try adjusting your search filters</p>
                            </td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>

        <!-- Summary -->
        <div class="mt-3 text-center">
            <small class="text-muted">
                Showing {{ $tickets->firstItem() ?? 0 }} to {{ $tickets->lastItem() ?? 0 }} 
                of {{ $tickets->total() }} total tickets
            </small>
        </div>
    </div>

</x-app-layout>