<!DOCTYPE html>
<html class="no-js" lang="en">
<head>
    <meta charset="utf-8" />
    <meta http-equiv="x-ua-compatible" content="ie=edge" />
    <title>PACE - Complimentary Codes</title>
    <meta name="description" content="PACE Events" />
        <meta name="viewport" content="width=device-width, initial-scale=1" />
        <!-- Primary Meta Tags -->
        <meta name="title" content="PACE" />
        <meta name="description" content="Welcome to Pacesetter Entertainment, Nairobi's premier party and events company. Since 2023, we have been crafting unforgettable experiences that educate, motivate, and entertain. Specializing in event management and organization across Kenya, we bring innovation and excellence to every occasion. From corporate events to private celebrations, trust us to make your events remarkable." />
    
        <!-- Open Graph / Facebook -->
        <meta property="og:type" content="website" />
        <meta property="og:url" content="https://pace-gules.vercel.app/" />
        <meta property="og:title" content="PACE" />
        <meta property="og:description" content="Welcome to Pacesetter Entertainment, Nairobi's premier party and events company. Since 2023, we have been crafting unforgettable experiences that educate, motivate, and entertain. Specializing in event management and organization across Kenya, we bring innovation and excellence to every occasion. From corporate events to private celebrations, trust us to make your events remarkable." />
        <meta property="og:image" content="https://pace-gules.vercel.app/assets/img/logo/logo.png" />
    
        <!-- Twitter -->
        <meta property="twitter:card" content="summary_large_image" />
        <meta property="twitter:url" content="https://pace-gules.vercel.app/" />
        <meta property="twitter:title" content="PACE" />
        <meta property="twitter:description" content="Welcome to Pacesetter Entertainment, Nairobi's premier party and events company. Since 2023, we have been crafting unforgettable experiences that educate, motivate, and entertain. Specializing in event management and organization across Kenya, we bring innovation and excellence to every occasion. From corporate events to private celebrations, trust us to make your events remarkable." />
        <meta property="twitter:image" content="https://pace-gules.vercel.app/assets/img/logo/logo.png" />
    
    
        <link
          rel="shortcut icon"
          type="image/x-icon"
          href="assets/img/logo/logo.png"
        />
    <meta name="description" content="Generate complimentary codes for PACE events" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />

    <link rel="shortcut icon" type="image/x-icon" href="{{ asset('assets/img/logo/logo.png') }}" />
    <!-- CSS here -->
    <link rel="stylesheet" href="{{ asset('assets/css/bootstrap.min.css') }}" />
    <link rel="stylesheet" href="{{ asset('assets/css/animate.min.css') }}" />
    <link rel="stylesheet" href="{{ asset('assets/css/magnific-popup.css') }}" />
    <link rel="stylesheet" href="{{ asset('assets/css/fontawesome-all.min.css') }}" />
    <link rel="stylesheet" href="{{ asset('assets/css/flaticon_mycollection.css') }}" />
    <link rel="stylesheet" href="{{ asset('assets/css/swiper-bundle.min.css') }}" />
    <link rel="stylesheet" href="{{ asset('assets/css/odometer.css') }}" />
    <link rel="stylesheet" href="{{ asset('assets/css/default.css') }}" />
    <link rel="stylesheet" href="{{ asset('assets/css/main.css') }}" />
    <style>
        /* Breadcrumb area styling */
        .td-breadcrumb-area {
            position: relative;
            background: linear-gradient(rgba(0, 0, 0, 0.7), rgba(0, 0, 0, 0.1)), 
                        url("{{ asset('assets/img/logo/logo.png') }}") center center / cover no-repeat;
            padding: 80px 0;
            color: #fff;
            text-align: center;
            margin-bottom: 40px;
        }
        
        .td-breadcrumb-area .container {
            position: relative;
            z-index: 1;
        }
        
        .breadcrumb-title {
            font-size: 36px;
            font-weight: 700;
            margin-bottom: 15px;
        }
        
        /* Card styling */
        .card {
            border: none;
            border-radius: 10px;
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.1);
            margin-bottom: 40px;
            overflow: hidden;
        }
        
        .card-header {
            background-color: #4e2a87;
            color: white;
            font-size: 20px;
            font-weight: 600;
            border-radius: 10px 10px 0 0 !important;
            padding: 15px 20px;
            display: flex;
            flex-wrap: wrap;
            justify-content: space-between;
            align-items: center;
        }
        
        .card-body {
            padding: 25px;
        }
        
        /* Button styling */
        .btn-primary {
            background-color: #4e2a87;
            border-color: #4e2a87;
            padding: 10px 25px;
            font-weight: 600;
            transition: all 0.3s;
        }
        
        .btn-primary:hover {
            background-color: #3a1d66;
            border-color: #3a1d66;
        }
        
        .btn-outline-primary {
            color: #4e2a87;
            border-color: #4e2a87;
        }
        
        .btn-outline-primary:hover {
            background-color: #4e2a87;
            color: white;
        }
        
        .btn-sm {
            padding: 5px 15px;
            font-size: 14px;
        }
        
        /* Alert styling */
        .alert-success {
            background-color: #d4edda;
            color: #155724;
            border-color: #c3e6cb;
            padding: 15px;
            margin-bottom: 20px;
            border-radius: 5px;
        }
        
        /* Table styling */
        .table-responsive {
            overflow-x: auto;
            -webkit-overflow-scrolling: touch;
        }
        
        table {
            width: 100%;
            border-collapse: collapse;
            min-width: 600px;
        }
        
        th, td {
            padding: 12px 15px;
            text-align: left;
            border-bottom: 1px solid #ddd;
            vertical-align: middle;
        }
        
        th {
            background-color: #f8f9fa;
            font-weight: 600;
            white-space: nowrap;
        }
        
        /* Badge styling */
        .badge {
            padding: 5px 10px;
            border-radius: 4px;
            font-size: 12px;
            font-weight: 600;
            display: inline-block;
        }
        
        .badge-primary {
            background-color: #4e2a87;
            color: white;
        }
        
        .badge-success {
            background-color: #28a745;
            color: white;
        }
        
        .badge-danger {
            background-color: #dc3545;
            color: white;
        }
        
        .badge-info {
            background-color: #17a2b8;
            color: white;
        }
        
        .badge-secondary {
            background-color: #6c757d;
            color: white;
        }
        
        /* Responsive adjustments */
        @media (max-width: 1199px) {
            .td-breadcrumb-area {
                padding: 70px 0;
            }
            
            .breadcrumb-title {
                font-size: 32px;
            }
            
            .card-header {
                font-size: 18px;
            }
        }
        
        @media (max-width: 991px) {
            .td-breadcrumb-area {
                padding: 60px 0;
                margin-bottom: 30px;
            }
            
            .breadcrumb-title {
                font-size: 28px;
            }
            
            .card-body {
                padding: 20px;
            }
            
            th, td {
                padding: 10px 12px;
            }
        }
        
        @media (max-width: 767px) {
            .td-breadcrumb-area {
                padding: 50px 0;
            }
            
            .breadcrumb-title {
                font-size: 24px;
            }
            
            .card-header {
                flex-direction: column;
                align-items: flex-start;
                gap: 10px;
            }
            
            .card-header a {
                width: 100%;
                text-align: center;
            }
            
            .table-responsive {
                border: 1px solid #ddd;
                border-radius: 5px;
            }
            
            th, td {
                padding: 8px 10px;
                font-size: 14px;
            }
        }
        
        @media (max-width: 575px) {
            .td-breadcrumb-area {
                padding: 40px 0;
            }
            
            .breadcrumb-title {
                font-size: 22px;
            }
            
            .card-header {
                font-size: 16px;
                padding: 12px 15px;
            }
            
            .alert-success {
                padding: 12px;
                font-size: 14px;
            }
            
            .badge {
                font-size: 11px;
                padding: 4px 8px;
            }
        }
        
        /* Copy button animation */
        @keyframes fadeIn {
            from { opacity: 0; }
            to { opacity: 1; }
        }
        
        .copy-feedback {
            display: none;
            position: fixed;
            bottom: 20px;
            left: 50%;
            transform: translateX(-50%);
            background-color: #4e2a87;
            color: white;
            padding: 10px 20px;
            border-radius: 5px;
            z-index: 1000;
            animation: fadeIn 0.3s ease-in-out;
        }
    </style>
</head>

<body>
    <!-- Preloader Start -->
    <div class="preloader">
        <div class="loader"></div>
    </div>
    <!-- Preloader End -->

    <!-- Scroll-top -->
    <button class="scroll__top scroll-to-target" data-target="html">
        <i class="fa-sharp fa-regular fa-arrow-up"></i>
    </button>
    <!-- Scroll-top-end-->

    <!-- header-area -->
    <header class="td-header-height">
        <div class="td-header__area z-index-999 td-transparent">
            <div class="td-header-3-top d-none d-lg-block">
                <div class="container-fluid container-1680">
                    <div class="row">
                        <div class="col-lg-6">
                            <div class="td-header-3-top-info">
                                <span><a href="#"><i class="flaticon-gps"></i>Nairobi, Kenya</a></span>
                                <span class="dvdr">/</span>
                                <span><a href="tel:254711871122"><i class="flaticon-phone"></i>Customer Care </a></span>
                            </div>
                        </div>
                        <div class="col-lg-6">
                            <div class="d-none d-lg-block">
                                <div class="td-header-3-top-social d-flex align-items-center justify-content-end">
                                    <span class="td-email">
                                        <a href="mailto:Thepacesettertalentshow@gmail.com">
                                            <i class="flaticon-mail"></i>Thepacesettertalentshow@gmail.com
                                        </a>
                                    </span>
                                    <span class="dvdr">/</span>
                                    <span>
                                        <a href="https://www.facebook.com/p/The-Pace-setter-Mag-61550425191042/">
                                            <i class="fa-brands fa-facebook"></i>
                                        </a>
                                    </span>
                                    <span>
                                        <a href="https://x.com/the_pace_mag">
                                            <svg width="19" height="19" viewBox="0 0 19 19" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                <path d="M13.8679 1.60596H16.4382L10.8229 8.02398L17.4289 16.7575H12.2564L8.20515 11.4607L3.56956 16.7575H0.997689L7.00391 9.89267L0.666687 1.60596H5.97049L9.6325 6.44745L13.8679 1.60596ZM12.9658 15.219H14.3901L5.1966 3.06361H3.66824L12.9658 15.219Z" fill="currentColor"/>
                                            </svg>
                                        </a>
                                    </span>
                                    <span>
                                        <a href="https://www.instagram.com/pace_setter_mag/">
                                            <i class="fa-brands fa-instagram"></i>
                                        </a>
                                    </span>
                                    <span>
                                        <a href="https://wa.me/254726846918?text=Hello%20Pace%20Setter,%20I%20want%20to%20book%20an%20event">
                                            <i class="fa-brands fa-whatsapp"></i>
                                        </a>
                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div id="header-sticky" class="header-mobile-spacing">
                <div class="container-fluid container-1680">
                    <div class="row align-items-center">
                        <div class="col-xxl-9 col-xl-9 col-6">
                            <div class="tdmenu__wrap d-flex align-items-center justify-content-between">
                                <div class="logo">
                                    <a class="logo-1 logo-sticky-none" href="/">
                                        <img data-width="150" src="{{ asset('assets/img/logo/logo.png') }}" alt="Logo"/>
                                    </a>
                                    <a class="logo-2 d-none" href="/">
                                        <img data-width="150" src="{{ asset('assets/img/logo/logo.png') }}" alt="Logo"/>
                                    </a>
                                </div>
                                <nav class="mr-40 tdmenu__nav tdmenu-3 ml-50 d-none d-xl-flex">
                                    <div class="tdmenu__navbar-wrap tdmenu__main-menu">
                                        <ul class="navigation">
                                            <li class="menu-item-has-children"><a href="/">Home</a></li>
                                            <li class="menu-item-has-children"><a href="#">Events</a></li>
                                            <li class="menu-item-has-children"><a href="#">Speakers</a></li>
                                            <li class="menu-item-has-children"><a href="{{ route('contact') }}">Contact</a></li>
                                            <li class="menu-item-has-children">
                                                <a href="{{ route('ticket', ['slug' => $highlightedEvent->slug]) }}" 
                                                   class="buy-ticket-link"
                                                   data-event-id="{{ $highlightedEvent->id }}"
                                                   data-amount="{{ $highlightedEvent->tickets['early_bird'] }}">
                                                    Buy Ticket                            
                                                </a>
                                            </li>
                                        </ul>
                                    </div>
                                </nav>
                            </div>
                        </div>
                        <div class="col-xxl-3 col-xl-3 col-6">
                            <div class="td-menu-right-action td-menu-right-action-3 d-flex align-items-center justify-content-end">
                                <div class="ml-20 td-header-menu-bar lh-1 p-relative">
                                    <button class="tdmenu-offcanvas-open-btn mobile-nav-toggler d-block d-xl-none">
                                        <span></span>
                                        <span></span>
                                        <span></span>
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Mobile Menu  -->
        <div class="tdmobile__menu">
            <nav class="tdmobile__menu-box">
                <div class="close-btn"><i class="fa-solid fa-xmark"></i></div>
                <div class="nav-logo">
                    <a href="/"><img src="{{ asset('assets/img/logo/logo.png') }}" alt="logo"/></a>
                </div>
                <div class="tdmobile__menu-outer">
                    <!--Here Menu Will Come Automatically Via Javascript / Same Menu as in Header-->
                </div>
                <div class="social-links">
                    <ul class="list-wrap">
                        <li>
                            <a href="https://www.facebook.com/p/The-Pace-setter-Mag-61550425191042/"><i class="fab fa-facebook-f"></i></a>
                        </li>
                        <li>
                            <a href="https://x.com/the_pace_mag"><i class="fab fa-twitter"></i></a>
                        </li>
                        <li>
                            <a href="https://www.instagram.com/pace_setter_mag/"><i class="fab fa-instagram"></i></a>
                        </li>
                        <li>
                            <a href="http://www.youtube.com/@ThePaceSetterMag"><i class="fab fa-youtube"></i></a>
                        </li>
                    </ul>
                </div>
            </nav>
        </div>
        <div class="tdmobile__menu-backdrop"></div>
        <!-- End Mobile Menu -->

        <!-- offCanvas-menu -->
        <div class="offCanvas__info">
            <div class="offCanvas__close-icon menu-close">
                <button><i class="fa-sharp fa-regular fa-xmark"></i></button>
            </div>
            <div class="offCanvas__logo mb-30">
                <a href="/"><img src="{{ asset('assets/img/logo/logo.png') }}" alt="Logo"/></a>
            </div>
            <div class="offCanvas__side-info mb-30">
                <div class="contact-list mb-30">
                    <h4>Office Address</h4>
                    <a href="https://www.google.com/maps" target="_blank">
                        Nairobi <br />Kenya
                    </a>
                </div>
                <div class="contact-list mb-30">
                    <h4>Phone Number</h4>
                    <a href="tel:(090)87658654385">+0989 7876 9865 9</a>
                    <a href="tel:(090)87658654385">+(090) 8765 86543 85</a>
                </div>
                <div class="contact-list mb-30">
                    <h4>Email Address</h4>
                    <a href="mailto:Thepacesettertalentshow@gmail.com">Thepacesettertalentshow@gmail.com</a>
                    <a href="mailto:Thepacesettertalentshow@gmail.com">Thepacesettertalentshow@gmail.com</a>
                </div>
            </div>
            <div class="offCanvas__social-icon mt-30">
                <a href="javascript:void(0)"><i class="fab fa-facebook-f"></i></a>
                <a href="javascript:void(0)"><i class="fab fa-twitter"></i></a>
                <a href="javascript:void(0)"><i class="fab fa-google-plus-g"></i></a>
                <a href="javascript:void(0)"><i class="fab fa-instagram"></i></a>
            </div>
        </div>
        <div class="offCanvas__overly"></div>
        <!-- offCanvas-menu-end -->
    </header>
    <!-- header-area-end -->

    <!-- main-area -->
    <main>
        <!-- Breadcrumb area -->
        <section class="td-breadcrumb-area">
            <div class="container">
                <div class="row">
                    <div class="col-12">
                        <h1 class="breadcrumb-title">Complimentary Codes</h1>
                    </div>
                </div>
            </div>
        </section>
        
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-md-12">
                    <div class="card">
                        <div class="card-header d-flex justify-content-between align-items-center">
                            <span>Complimentary Codes</span>
                            <a href="{{ route('complimentary.codes.create') }}" class="text-white rounded shadow-lg btn btn-success btn-sm">Generate New Codes</a>
                        </div>

                        <div class="card-body">
                            @if(session('success'))
                                <div class="alert alert-success">
                                    {{ session('success') }}
                                </div>
                            @endif
                            
                            <div class="table-responsive">
                                <table class="table">
                                    <thead>
                                        <tr>
                                            <th>Code</th>
                                            <th>Event</th>
                                            <th>Status</th>
                                            <th>Expires</th>
                                            <th>Generated By</th>
                                            <th>Used By</th>
                                            <th>Actions</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach($codes as $code)
                                            <tr>
                                                <td><code>{{ $code->code }}</code></td>
                                                <td>{{ $code->event->name }}</td>
                                                <td>
                                                    @if($code->is_used)
                                                        <span class="badge badge-info">Used</span>
                                                    @elseif($code->expires_at < now())
                                                        <span class="badge badge-danger">Expired</span>
                                                    @else
                                                        <span class="badge badge-success">Active</span>
                                                    @endif
                                                </td>
                                                <td>{{ $code->expires_at->format('M j, Y H:i') }}</td>
                                                <td>{{ $code->generated_by_name ?? 'System' }}</td>
                                                <td>{{ $code->used_by_name ?? 'Not used' }}</td>
                                                <td>
                                                    @if(!$code->is_used && $code->expires_at > now())
                                                        <button class="btn btn-sm btn-outline-primary copy-btn" data-code="{{ $code->code }}">Copy</button>
                                                    @endif
                                                </td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                                                    {{ $codes->links() }}

                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Copy feedback element -->
        <div class="copy-feedback">Code copied to clipboard!</div>
    </main>
    <!-- main-area-end -->

    <!-- footer-area-start -->
    <footer>
        <div class="td-footer-area td-footer-2-spacing bg-position" data-background="{{ asset('assets/img/footer/bg.jpg') }}">
            <div class="container">
                <div class="row mb-15">
                    <div class="col-xl-3 col-lg-3 col-md-5">
                        <div class="mb-40 td-footer-widget">
                            <div class="mb-20 td-footer-logo">
                                <a href="/"><img src="{{ asset('assets/img/logo/logo.png') }}" alt="logo"/></a>
                            </div>
                            <p class="mb-10 text">
                                Nairobi,Kenya
                            </p>
                            <a class="mb-10 number d-inline-block" href="tel:+254726846918">+(254) 726-846 918</a>
                            <a class="email" href="mailto:Thepacesettertalentshow@gmail.com">Thepacesettertalentshow@gmail.com</a>
                        </div>
                    </div>
                    <div class="col-xl-5 col-lg-4 col-md-7">
                        <div class="mb-40 td-footer-widget space ml-90">
                            <h3 class="mb-20 td-footer-title">Quick links</h3>
                            <div class="row">
                                <div class="col-lg-6 col-md-6 col-sm-6">
                                    <div class="td-footer-links">
                                        <ul>
                                            <li><a href="#">About this Event</a></li>
                                            <li><a href="#">Venue</a></li>
                                            <li><a href="#">Speakers</a></li>
                                            <li><a href="#">Agenda</a></li>
                                            <li><a href="#">Sponsors</a></li>
                                        </ul>
                                    </div>
                                </div>
                                <div class="col-lg-6 col-md-6 col-sm-6">
                                    <div class="td-footer-links">
                                        <ul>
                                            <li><a href="#">News</a></li>
                                            <li>
                                                <a href="{{ route('ticket', ['slug' => $highlightedEvent->slug]) }}" 
                                                   class="buy-ticket-link"
                                                   data-event-id="{{ $highlightedEvent->id }}"
                                                   data-amount="{{ $highlightedEvent->tickets['early_bird'] }}">
                                                    Buy Ticket                            
                                                </a>
                                            </li>
                                            <li><a href="#">Benefits</a></li>
                                            <li><a href="tel:254711871122">Customer Care</a></li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-xl-4 col-lg-5 col-md-6">
                        <div class="mb-40 td-footer-2-widget space ml-90">
                            <h3 class="td-footer-title mb-25"></h3>
                            <div class="row gx-10">
                                <a aria-label="Chat on WhatsApp" 
                                   href="https://wa.me/254726846918?text=Hello%20Pace%20Setter,%20I%20want%20to%20book%20an%20event" 
                                   target="_blank">
                                    <img alt="Chat on WhatsApp" src="{{ asset('assets/img/whatsapp/WhatsAppButtonGreenLarge.png') }}" />
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-12">
                        <div class="pt-40 td-footer-bottom pb-15">
                            <div class="row align-items-center">
                                <div class="col-md-9">
                                    <div class="td-footer-bottom-copyright mb-30">
                                        <p>
                                            Copyright © <span id="current-year"></span> pacesetter.co.ke All rights reserved.
                                        </p>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="text-right td-footer-bottom-social mb-30">
                                        <span>
                                            <a href="https://www.instagram.com/pace_setter_mag/">
                                                <i class="fa-brands fa-instagram"></i>
                                            </a>
                                        </span>
                                        <span>
                                            <a href="https://x.com/the_pace_mag">
                                                <svg width="21" height="18" viewBox="0 0 21 18" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                    <path d="M16.3783 0.111328H19.3942L12.8054 7.64181L20.5565 17.8891H14.4875L9.73399 11.6742L4.2949 17.8891H1.27723L8.32453 9.83441L0.888855 0.111328H7.11199L11.4087 5.79201L16.3783 0.111328ZM15.3199 16.084H16.991L6.20396 1.82164H4.41068L15.3199 16.084Z" fill="currentColor"/>
                                                </svg>
                                            </a>
                                        </span>
                                        <span>
                                            <a href="https://wa.me/254726846918?text=Hello%20Pace%20Setter,%20I%20want%20to%20book%20an%20event">
                                                <i class="fa-brands fa-whatsapp"></i>
                                            </a>
                                        </span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </footer>
    <!-- footer-area-end -->

    <!-- JS here -->
    <script src="{{ asset('assets/js/vendor/jquery.js') }}"></script>
    <script src="{{ asset('assets/js/bootstrap.min.js') }}"></script>
    <script src="{{ asset('assets/js/isotope.pkgd.min.js') }}"></script>
    <script src="{{ asset('assets/js/ion.rangeSlider.min.js') }}"></script>
    <script src="{{ asset('assets/js/imagesloaded.pkgd.min.js') }}"></script>
    <script src="{{ asset('assets/js/jquery.magnific-popup.min.js') }}"></script>
    <script src="{{ asset('assets/js/jquery.odometer.min.js') }}"></script>
    <script src="{{ asset('assets/js/jquery-appear.js') }}"></script>
    <script src="{{ asset('assets/js/swiper-bundle.min.js') }}"></script>
    <script src="{{ asset('assets/js/Jarallax.js') }}"></script>
    <script src="{{ asset('assets/js/nice-select.js') }}"></script>
    <script src="{{ asset('assets/js/ajax-form.js') }}"></script>
    <script src="{{ asset('assets/js/wow.min.js') }}"></script>
    <script src="{{ asset('assets/js/main.js') }}"></script>
    <script>
        // Get the current year
        document.addEventListener('DOMContentLoaded', function() {
            const year = new Date().getFullYear();
            document.getElementById("current-year").textContent = year;
            
            // Copy button functionality with improved feedback
            const copyButtons = document.querySelectorAll('.copy-btn');
            const copyFeedback = document.querySelector('.copy-feedback');
            
            copyButtons.forEach(button => {
                button.addEventListener('click', function() {
                    const code = this.getAttribute('data-code');
                    navigator.clipboard.writeText(code).then(() => {
                        // Show feedback message
                        copyFeedback.style.display = 'block';
                        setTimeout(() => {
                            copyFeedback.style.display = 'none';
                        }, 2000);
                        
                        // Button animation
                        const originalText = this.textContent;
                        this.textContent = 'Copied!';
                        this.classList.remove('btn-outline-primary');
                        this.classList.add('btn-success');
                        
                        setTimeout(() => {
                            this.textContent = originalText;
                            this.classList.remove('btn-success');
                            this.classList.add('btn-outline-primary');
                        }, 2000);
                    }).catch(err => {
                        console.error('Failed to copy text: ', err);
                        copyFeedback.textContent = 'Failed to copy!';
                        copyFeedback.style.backgroundColor = '#dc3545';
                        copyFeedback.style.display = 'block';
                        setTimeout(() => {
                            copyFeedback.style.display = 'none';
                            copyFeedback.textContent = 'Code copied to clipboard!';
                            copyFeedback.style.backgroundColor = '#4e2a87';
                        }, 2000);
                    });
                });
            });
            
            // Adjust table header on mobile
            function adjustTableHeader() {
                if (window.innerWidth < 768) {
                    document.querySelectorAll('th').forEach(th => {
                        th.style.whiteSpace = 'nowrap';
                    });
                }
            }
            
            // Run on load and resize
            adjustTableHeader();
            window.addEventListener('resize', adjustTableHeader);
        });
    </script>
</body>
</html>