<!DOCTYPE html>
<html class="no-js" lang="en">
  <head>
    <meta charset="utf-8" />
    <meta http-equiv="x-ua-compatible" content="ie=edge" />
    <title>PACE - Complimentary Codes</title>
   <meta name="description" content="PACE Events" />
        <meta name="viewport" content="width=device-width, initial-scale=1" />
        <!-- Primary Meta Tags -->
        <meta name="title" content="PACE" />
        <meta name="description" content="Welcome to Pacesetter Entertainment, Nairobi's premier party and events company. Since 2023, we have been crafting unforgettable experiences that educate, motivate, and entertain. Specializing in event management and organization across Kenya, we bring innovation and excellence to every occasion. From corporate events to private celebrations, trust us to make your events remarkable." />
    
        <!-- Open Graph / Facebook -->
        <meta property="og:type" content="website" />
        <meta property="og:url" content="https://pace-gules.vercel.app/" />
        <meta property="og:title" content="PACE" />
        <meta property="og:description" content="Welcome to Pacesetter Entertainment, Nairobi's premier party and events company. Since 2023, we have been crafting unforgettable experiences that educate, motivate, and entertain. Specializing in event management and organization across Kenya, we bring innovation and excellence to every occasion. From corporate events to private celebrations, trust us to make your events remarkable." />
        <meta property="og:image" content="https://pace-gules.vercel.app/assets/img/logo/logo.png" />
    
        <!-- Twitter -->
        <meta property="twitter:card" content="summary_large_image" />
        <meta property="twitter:url" content="https://pace-gules.vercel.app/" />
        <meta property="twitter:title" content="PACE" />
        <meta property="twitter:description" content="Welcome to Pacesetter Entertainment, Nairobi's premier party and events company. Since 2023, we have been crafting unforgettable experiences that educate, motivate, and entertain. Specializing in event management and organization across Kenya, we bring innovation and excellence to every occasion. From corporate events to private celebrations, trust us to make your events remarkable." />
        <meta property="twitter:image" content="https://pace-gules.vercel.app/assets/img/logo/logo.png" />
    
    
        <link
          rel="shortcut icon"
          type="image/x-icon"
          href="assets/img/logo/logo.png"
        />

    <link rel="shortcut icon" type="image/x-icon" href="{{ asset('assets/img/logo/logo.png') }}" />
    <!-- CSS here -->
    <link rel="stylesheet" href="{{ asset('assets/css/bootstrap.min.css') }}" />
    <link rel="stylesheet" href="{{ asset('assets/css/animate.min.css') }}" />
    <link rel="stylesheet" href="{{ asset('assets/css/magnific-popup.css') }}" />
    <link rel="stylesheet" href="{{ asset('assets/css/fontawesome-all.min.css') }}" />
    <link rel="stylesheet" href="{{ asset('assets/css/flaticon_mycollection.css') }}" />
    <link rel="stylesheet" href="{{ asset('assets/css/swiper-bundle.min.css') }}" />
    <link rel="stylesheet" href="{{ asset('assets/css/odometer.css') }}" />
    <link rel="stylesheet" href="{{ asset('assets/css/default.css') }}" />
    <link rel="stylesheet" href="{{ asset('assets/css/main.css') }}" />
    <!-- Toastr CSS -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css" rel="stylesheet">
    <style>
      /* Updated Breadcrumb area styling */
      .td-breadcrumb-area {
        position: relative;
        background: url("{{ asset('assets/img/logo/logo.png') }}") center center / cover no-repeat;
        padding: 80px 0;
        color: #fff;
        margin-bottom: 40px;
      }
      
      .td-breadcrumb-area::before {
        content: "";
        position: absolute;
        inset: 0;
        background: rgba(0, 0, 0, 0.5); /* Dark overlay */
      }
      
      .td-breadcrumb-area .container {
        position: relative;
        z-index: 1;
      }
      
      .td-breadcrumb-title {
        font-size: 36px;
        font-weight: 700;
        margin-bottom: 15px;
      }
      
      .td-breadcrumb-list ul {
        list-style: none;
        padding: 0;
        margin: 0;
        display: flex;
        align-items: center;
      }
      
      .td-breadcrumb-list li {
        display: flex;
        align-items: center;
      }
      
      .td-breadcrumb-list li a {
        color: #fff;
        text-decoration: none;
        transition: color 0.3s;
      }
      
      .td-breadcrumb-list li a:hover {
        color: #6c04f5;
      }
      
      .td-breadcrumb-list li.pages {
        color: #fff;
        opacity: 0.8;
      }
      
      .td-breadcrumb-list .fa-angle-right {
        margin: 0 10px;
        font-size: 14px;
      }
      
      /* Form styling */
      .card {
        border: none;
        border-radius: 8px;
        box-shadow: -5px 5px 15px rgba(1, 6, 36, 0.5);
        margin-bottom: 40px;
        max-width: 500px;
        margin-left: auto;
        margin-right: auto;
        background: linear-gradient(to right, rgb(252, 249, 249), rgb(243, 241, 241), white);
      }
      
      .card-header {
        background-color: #6c04f5;
        color: white;
        font-size: 20px;
        font-weight: 600;
        border-radius: 8px 8px 0 0 !important;
        padding: 15px 20px;
      }
      
      .card-body {
        padding: 30px;
      }
      
      /* Updated form styling to match new design */
      .form-input {
        background-color: #fff;
        border: none;
        border-radius: 5px;
        padding: 12px;
        margin-bottom: 8px;
        transition: all 0.3s;
        width: 100%;
        box-shadow: 0 4px 10px rgba(248, 247, 247, 0.979);
      }
      
      .form-input:focus {
        background-color: #fff;
        border-color: #80bdff;
        outline: 0;
        box-shadow: 0 4px 10px rgba(248, 247, 247, 0.979), 0 0 0 0.2rem rgba(108, 4, 245, 0.25);
      }
      
      .form-btn {
        background-color: #6c04f5;
        color: white;
        border: none;
        border-radius: 5px;
        padding: 12px;
        font-weight: 600;
        display: flex;
        align-items: center;
        justify-content: center;
        width: 100%;
        transition: background-color 0.3s;
        margin-top: 1rem;
        box-shadow: 0 4px 10px rgba(0, 0, 0, 0.2);
      }
      
      .form-btn:hover {
        background-color: #db2777;
        color: white;
      }
      
      .invalid-feedback {
        display: none;
        width: 100%;
        margin-top: 0.25rem;
        font-size: 0.875em;
        color: #dc3545;
      }
      
      .was-validated .form-control:invalid ~ .invalid-feedback,
      .form-control.is-invalid ~ .invalid-feedback {
        display: block;
      }
      
      .form-text.text-muted {
        font-size: 0.8rem;
        margin-top: 0.25rem;
        color: #6c757d !important;
      }
      
      .mb-3 {
        margin-bottom: 1rem !important;
      }
      
      .position-relative {
        position: relative;
      }
      
      .spinner-border-sm {
        width: 1rem;
        height: 1rem;
      }
      
      .phone-examples {
        font-size: 0.75rem;
        color: #6c757d;
        margin-top: 0.25rem;
      }
      
      @media (max-width: 1199px) {
        .td-breadcrumb-area {
          padding: 70px 0;
        }
        .td-breadcrumb-title {
          font-size: 32px;
        }
      }
      
      @media (max-width: 991px) {
        .td-breadcrumb-area {
          padding: 60px 0;
          margin-bottom: 30px;
        }
        .td-breadcrumb-title {
          font-size: 28px;
        }
        .card-body {
          padding: 25px;
        }
      }
      
      @media (max-width: 767px) {
        .td-breadcrumb-area {
          padding: 50px 0;
        }
        .td-breadcrumb-title {
          font-size: 24px;
        }
        .card {
          margin-bottom: 30px;
          margin-left: 15px;
          margin-right: 15px;
        }
        .form-input {
          padding: 10px 12px;
        }
      }
      
      @media (max-width: 575px) {
        .td-breadcrumb-area {
          padding: 40px 0;
        }
        .td-breadcrumb-title {
          font-size: 22px;
        }
        .card-header {
          font-size: 18px;
          padding: 12px 15px;
        }
        .td-breadcrumb-list ul {
          flex-wrap: wrap;
        }
      }
    </style>
  </head>

  <body>
    <div class="preloader">
      <div class="loader"></div>
    </div>

    <button class="scroll__top scroll-to-target" data-target="html">
      <i class="fa-sharp fa-regular fa-arrow-up"></i>
    </button>

    <main>
      <!-- Your existing header HTML code remains exactly the same -->
      <header class="td-header-height">
        <div class="td-header__area z-index-999 td-transparent">
          <!-- Top Bar -->
          <div class="td-header-3-top d-none d-lg-block">
            <div class="container-fluid container-1680">
              <div class="row">
                <div class="col-lg-6">
                  <div class="td-header-3-top-info">
                    <span><a href="#"><i class="flaticon-gps"></i>Nairobi, Kenya</a></span>
                    <span class="dvdr">/</span>
                    <span><a href="tel:254711871122"><i class="flaticon-phone"></i>Customer Care</a></span>
                  </div>
                </div>
                <div class="col-lg-6">
                  <div class="d-none d-lg-block">
                    <div class="td-header-3-top-social d-flex align-items-center justify-content-end">
                      <span class="td-email">
                        <a href="mailto:Thepacesettertalentshow@gmail.com">
                          <i class="flaticon-mail"></i>Thepacesettertalentshow@gmail.com
                        </a>
                      </span>
                      <span class="dvdr">/</span>
                      <span>
                        <a href="https://www.facebook.com/p/The-Pace-setter-Mag-61550425191042/">
                          <i class="fa-brands fa-facebook"></i>
                        </a>
                      </span>
                      <span>
                        <a href="https://x.com/the_pace_mag">
                          <svg width="19" height="19" viewBox="0 0 19 19" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path d="M13.8679 1.60596H16.4382L10.8229 8.02398L17.4289 16.7575H12.2564L8.20515 11.4607L3.56956 16.7575H0.997689L7.00391 9.89267L0.666687 1.60596H5.97049L9.6325 6.44745L13.8679 1.60596ZM12.9658 15.219H14.3901L5.1966 3.06361H3.66824L12.9658 15.219Z" fill="currentColor"/>
                          </svg>
                        </a>
                      </span>
                      <span>
                        <a href="https://www.instagram.com/pace_setter_mag/">
                          <i class="fa-brands fa-instagram"></i>
                        </a>
                      </span>
                      <span>
                        <a href="https://wa.me/254726846918?text=Hello%20Pace%20Setter,%20I%20want%20to%20book%20an%20event">
                          <i class="fa-brands fa-whatsapp"></i>
                        </a>
                      </span>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>

          <!-- Main Navigation -->
          <div id="header-sticky" class="mt-5 header-mobile-spacing">
            <div class="container-fluid container-1680">
              <div class="row align-items-center">
                <div class="col-xxl-9 col-xl-9 col-6">
                  <div class="tdmenu__wrap d-flex align-items-center justify-content-between">
                    <div class="logo">
                      {{-- <a class="logo-1 logo-sticky-none" href="{{ route('dashboard') }}">
                        <img data-width="150" src="{{ asset('assets/img/logo/logo.png') }}" alt="Logo">
                      </a> --}}
                      <a class="logo-2 d-none" href="{{ route('dashboard') }}">
                        <img data-width="150" src="{{ asset('assets/img/logo/logo.png') }}" alt="Logo">
                      </a>
                    </div>
                    <nav class="mr-40 tdmenu__nav tdmenu-3 ml-50 d-none d-xl-flex">
                      <div class="tdmenu__navbar-wrap tdmenu__main-menu">
                        <ul class="navigation">
                          <li><a href="{{ route('dashboard') }}">Home</a></li>                    
                          <!-- Authentication Links -->
                          @auth
                            <li class="menu-item-has-children">
                              <a href="#">
                                <i class="far fa-user-circle me-2"></i>{{ Auth::user()->name }}
                              </a>
                              <ul class="sub-menu">
                                <li><a href="{{ route('profile.edit') }}"><i class="far fa-user me-2"></i>Profile</a></li>
                                <li>
                                  <form method="POST" action="{{ route('logout') }}">
                                    @csrf
                                    <a href="{{ route('logout') }}" onclick="event.preventDefault(); this.closest('form').submit();">
                                      <i class="fas fa-sign-out-alt me-2"></i>Log Out
                                    </a>
                                  </form>
                                </li>
                              </ul>
                            </li>
                          @else
                            <li><a href="{{ route('login') }}"><i class="fas fa-sign-in-alt me-2"></i>Login</a></li>
                            <li><a href="{{ route('register') }}"><i class="fas fa-user-plus me-2"></i>Register</a></li>
                          @endauth
                        </ul>
                      </div>
                    </nav>
                  </div>
                </div>
                <div class="col-xxl-3 col-xl-3 col-6">
                  <div class="td-menu-right-action td-menu-right-action-3 d-flex align-items-center justify-content-end">
                    <div class="ml-20 td-header-menu-bar lh-1 p-relative">
                      <button class="tdmenu-offcanvas-open-btn mobile-nav-toggler d-block d-xl-none">
                        <span></span>
                        <span></span>
                        <span></span>
                      </button>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>

        <!-- Mobile Menu -->
        <div class="tdmobile__menu">
          <nav class="tdmobile__menu-box">
            <div class="close-btn"><i class="fa-solid fa-xmark"></i></div>
            <div class="nav-logo">
              <a href="/"><img src="{{ asset('assets/img/logo/logo.png') }}" alt="logo"></a>
            </div>
            <div class="tdmobile__menu-outer">
              <ul class="navigation">          
                @auth
                  <li class="menu-item-has-children">
                    <ul class="sub-menu">
                      <li><a href="{{ route('profile.edit') }}"><i class="far fa-user me-2"></i>Profile</a></li>
                      <li>
                        <form method="POST" action="{{ route('logout') }}">
                          @csrf
                          <a href="{{ route('logout') }}" onclick="event.preventDefault(); this.closest('form').submit();">
                            <i class="fas fa-sign-out-alt me-2"></i>Log Out
                          </a>
                        </form>
                      </li>
                    </ul>
                  </li>
                @else
                  <li><a href="{{ route('login') }}"><i class="fas fa-sign-in-alt me-2"></i>Login</a></li>
                  <li><a href="{{ route('register') }}"><i class="fas fa-user-plus me-2"></i>Register</a></li>
                @endauth
              </ul>
            </div>
            <div class="social-links">
              <ul class="list-wrap">
                <li><a href="https://www.facebook.com/p/The-Pace-setter-Mag-61550425191042/"><i class="fab fa-facebook-f"></i></a></li>
                <li><a href="https://x.com/the_pace_mag"><i class="fab fa-twitter"></i></a></li>
                <li><a href="https://www.instagram.com/pace_setter_mag/"><i class="fab fa-instagram"></i></a></li>
                <li><a href="http://www.youtube.com/@ThePaceSetterMag"><i class="fab fa-youtube"></i></a></li>
              </ul>
            </div>
          </nav>
        </div>
        <!-- End Mobile Menu -->

        <!-- Offcanvas Menu -->
        <div class="offCanvas__info">
          <div class="offCanvas__close-icon menu-close">
            <button><i class="fa-sharp fa-regular fa-xmark"></i></button>
          </div>
          <div class="offCanvas__logo mb-30">
            <a href="/"><img src="{{ asset('assets/img/logo/logo.png') }}" alt="Logo"></a>
          </div>
          
          <div class="offCanvas__side-info mb-30">
            <div class="contact-list mb-30">
              <h4>Office Address</h4>
              <a href="https://www.google.com/maps" target="_blank">
                Nairobi <br> Kenya
              </a>
            </div>
            <div class="contact-list mb-30">
              <h4>Phone Number</h4>
              <a href="tel:(090)87658654385">+0989 7876 9865 9</a>
              <a href="tel:(090)87658654385">+(090) 8765 86543 85</a>
            </div>
            <div class="contact-list mb-30">
              <h4>Email Address</h4>
              <a href="mailto:Thepacesettertalentshow@gmail.com">Thepacesettertalentshow@gmail.com</a>
              <a href="mailto:Thepacesettertalentshow@gmail.com">Thepacesettertalentshow@gmail.com</a>
            </div>
            
            <!-- Account Section -->
            <div class="contact-list mb-30">
              <h4>Account</h4>
              @auth
                <a href="{{ route('profile.edit') }}"><i class="far fa-user me-2"></i>Profile</a>
                <form method="POST" action="{{ route('logout') }}">
                  @csrf
                  <a href="{{ route('logout') }}" onclick="event.preventDefault(); this.closest('form').submit();">
                    <i class="fas fa-sign-out-alt me-2"></i>Log Out
                  </a>
                </form>
              @else
                <a href="{{ route('login') }}"><i class="fas fa-sign-in-alt me-2"></i>Login</a>
                <a href="{{ route('register') }}"><i class="fas fa-user-plus me-2"></i>Register</a>
              @endauth
            </div>
          </div>
          
          <div class="offCanvas__social-icon mt-30">
            <a href="https://www.facebook.com/p/The-Pace-setter-Mag-61550425191042/"><i class="fab fa-facebook-f"></i></a>
            <a href="https://x.com/the_pace_mag"><i class="fab fa-twitter"></i></a>
            <a href="https://www.instagram.com/pace_setter_mag/"><i class="fab fa-instagram"></i></a>
            <a href="http://www.youtube.com/@ThePaceSetterMag"><i class="fab fa-youtube"></i></a>
          </div>
        </div>
        <div class="offCanvas__overly"></div>
        <!-- offCanvas-menu-end -->
      </header>
      <!-- header-area-end -->
        
      <!-- Updated Breadcrumb Section -->
      <div class="td-breadcrumb-area td-breadcrumb-spacing">
        <div class="container">
          <div class="row">
            <div class="col-lg-12">
              <div class="td-breadcrumb-title-wrap">
                <h2
                  class="mb-10 td-breadcrumb-title wow td-animetion-left"
                  data-wow-duration="1.5s"
                  data-wow-delay="0.3s"
                >
                  
                </h2>
                <div
                  class="mt-10 td-breadcrumb-list wow td-animetion-right"
                  data-wow-duration="1.5s"
                  data-wow-delay="0.3s"
                >
                  <ul>
                    <li><a href="{{ route('dashboard') }}">Admin</a></li>
                    <li>
                      <i class="fa-sharp fa-solid fa-angle-right fa-fw"></i>
                    </li>
                    <li class="pages">Complimentary Tickets</li>
                  </ul>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>      
      <div class="container">
        <div class="row justify-content-center">
          <div class="col-lg-10 col-md-12">
            <div class="card">
              <div class="text-white bg-white card-header align-center">
                <h3 class="mb-0 text-primary">Create Tickets</h3>
              </div>
              <div class="card-body">
                @if (session('success'))
                  <div class="alert alert-success">
                    {{ session('success') }}
                  </div>
                @endif
                @if ($errors->any())
                  <div class="alert alert-danger">
                    <ul>
                      @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                      @endforeach
                    </ul>
                  </div>
                @endif
                
                <form method="POST" action="{{ route('complimentary.codes.store') }}" id="ticketForm" class="needs-validation" novalidate>
                  @csrf
                  <div class="mb-3">
                    <select name="event_id" id="event_id" class="form-control form-input" required>
                      <option value="" disabled selected>Select Event *</option>
                      @foreach($events as $event)
                        <option value="{{ $event->id }}"
                          {{ $highlightedEvent && $highlightedEvent->id == $event->id ? 'selected' : '' }}>
                          {{ $event->name }} ({{ $event->date->format('M j, Y') }})
                        </option>
                      @endforeach
                    </select>
                    <div class="invalid-feedback">Please select an event</div>
                    @error('event_id')
                      <span class="text-danger">{{ $message }}</span>
                    @enderror
                  </div>
                  
                  <div class="mb-3">
                    <label class="form-label fw-semibold" style="color: #212529;">Ticket Type *</label>
                    <div class="d-flex gap-3">
                      <div class="form-check">
                        <input class="form-check-input" type="radio" name="ticket_type" id="ticketTypeNormal" value="normal" 
                               {{ old('ticket_type', 'normal') == 'normal' ? 'checked' : '' }} required>
                        <label class="form-check-label" for="ticketTypeNormal" style="cursor: pointer;">
                          <i class="bi bi-gift me-1" style="color: #D4AF37;"></i>
                          <strong>Normal Complimentary</strong>
                          <small class="d-block text-muted">Standard special guest ticket</small>
                        </label>
                      </div>
                      <div class="form-check">
                        <input class="form-check-input" type="radio" name="ticket_type" id="ticketTypeVip" value="vip"
                               {{ old('ticket_type') == 'vip' ? 'checked' : '' }} required>
                        <label class="form-check-label" for="ticketTypeVip" style="cursor: pointer;">
                          <i class="bi bi-gem me-1" style="color: #6B46C1;"></i>
                          <strong>VIP Complimentary</strong>
                          <small class="d-block text-muted">Premium VIP guest ticket</small>
                        </label>
                      </div>
                    </div>
                    @error('ticket_type')
                      <span class="text-danger">{{ $message }}</span>
                    @enderror
                  </div>
                  
                  <div class="mb-3 position-relative">
                    <input type="number" name="quantity" id="quantity" class="form-control form-input" 
                          min="1" max="20" value="{{ old('quantity', 1) }}" 
                          placeholder="Number of Tickets *" required>
                    <div class="invalid-feedback">Please enter a valid number of tickets (1-20)</div>
                    @error('quantity')
                      <span class="text-danger">{{ $message }}</span>
                    @enderror
                  </div>
                  
                  <div class="mb-3">
                    <input type="text" name="recipient_name" id="recipient_name" class="form-control form-input" 
                          value="{{ old('recipient_name') }}" placeholder="Recipient Name *" required
                          pattern="^[A-Za-z\s\-']+$" 
                          title="Please enter a valid name (letters, spaces, hyphens, and apostrophes only).">
                    <div class="invalid-feedback">Please enter a valid recipient name</div>
                    @error('recipient_name')
                      <span class="text-danger">{{ $message }}</span>
                    @enderror
                  </div>
                  
                  <div class="mb-3">
                    <input type="tel" name="recipient_phone" id="recipient_phone" class="form-control form-input" 
                          value="{{ old('recipient_phone') }}" placeholder="Phone Number *" required
                          title="Please enter a valid Kenyan phone number">
                    <div class="invalid-feedback" id="phoneValidationFeedback">Please enter a valid Kenyan phone number</div>
                    <div class="phone-examples">Accepted formats: 0712345678, 0112345678, +254712345678, 254712345678</div>
                    @error('recipient_phone')
                      <span class="text-danger">{{ $message }}</span>
                    @enderror
                  </div>
                  
                  <div class="mb-3">
                    <input type="email" name="recipient_email" id="recipient_email" class="form-control form-input" 
                          value="{{ old('recipient_email') }}" placeholder="Email *" required
                          pattern="^[a-zA-Z0-9._%+-]+@[a-zA-Z0-9.-]+\.[a-zA-Z]{2,}$" 
                          title="Please enter a valid email address">
                    <div class="invalid-feedback">Please enter a valid email address</div>
                    @error('recipient_email')
                      <span class="text-danger">{{ $message }}</span>
                    @enderror
                  </div>
                  
                  <div class="mb-3 d-none">
                    <select name="sms_template" id="sms_template" class="form-control form-input" required>
                      @foreach($templates as $key => $template)
                        <option value="{{ $key }}" {{ old('sms_template') == $key ? 'selected' : '' }}>
                          {{ $template['name'] }}
                        </option>
                      @endforeach
                    </select>
                    <div class="invalid-feedback">Please select a notification template</div>
                    @error('sms_template')
                      <span class="text-danger">{{ $message }}</span>
                    @enderror
                  </div>
                  
                  <input type="hidden" name="generated_by" value="admin">
                  
                  <button type="submit" class="form-btn" id="submitBtn">
                    <span class="submit-text">Submit</span>
                    <span class="spinner-border spinner-border-sm d-none" role="status" aria-hidden="true"></span>
                  </button>
                </form>
              </div>
            </div>
          </div>
        </div>
      </div>
      
    </main>
     <!-- footer-area-start -->
    <footer>
        <div class="td-footer-area td-footer-2-spacing bg-position" data-background="{{ asset('assets/img/footer/bg.jpg') }}">
            <div class="container">
                <div class="row mb-15">
                    <div class="col-xl-3 col-lg-3 col-md-5">
                        <div class="mb-40 td-footer-widget">
                            <div class="mb-20 td-footer-logo">
                                <a href="/"><img src="{{ asset('assets/img/logo/logo.png') }}" alt="logo"/></a>
                            </div>
                            <p class="mb-10 text">
                                Nairobi,Kenya
                            </p>
                            <a class="mb-10 number d-inline-block" href="tel:+254726846918">+(254) 726-846 918 </a>
                            <a class="email" href="mailto:Thepacesettertalentshow@gmail.com">Thepacesettertalentshow@gmail.com</a>
                        </div>
                    </div>
                    <div class="col-xl-5 col-lg-4 col-md-7">
                        <div class="mb-40 td-footer-widget space ml-90">
                            <h3 class="mb-20 td-footer-title">Quick links</h3>
                            <div class="row">
                                <div class="col-lg-6 col-md-6 col-sm-6">
                                    <div class="td-footer-links">
                                        <ul>
                                            <li><a href="#">About this Event</a></li>
                                            <li><a href="#">Venue</a></li>
                                            <li><a href="#">Speakers</a></li>
                                            <li><a href="#">Agenda</a></li>
                                            <li><a href="#">Sponsors</a></li>
                                        </ul>
                                    </div>
                                </div>
                                <div class="col-lg-6 col-md-6 col-sm-6">
                                    <div class="td-footer-links">
                                        <ul>
                                            <li><a href="#">News</a></li>
                                            <li>
                                                <a href="{{ route('ticket', ['slug' => $highlightedEvent->slug]) }}" 
                                                   class="buy-ticket-link"
                                                   data-event-id="{{ $highlightedEvent->id }}"
                                                   data-amount="{{ $highlightedEvent->tickets['early_bird'] }}">
                                                    Buy Ticket                            
                                                </a>
                                            </li>
                                            <li><a href="#">Benefits</a></li>
                                            <li><a href="tel:254711871122">Customer Care</a></li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-xl-4 col-lg-5 col-md-6">
                        <div class="mb-40 td-footer-2-widget space ml-90">
                            <h3 class="td-footer-title mb-25"></h3>
                            <div class="row gx-10">
                                <a aria-label="Chat on WhatsApp" 
                                   href="https://wa.me/254726846918?text=Hello%20Pace%20Setter,%20I%20want%20to%20book%20an%20event" 
                                   target="_blank">
                                    <img alt="Chat on WhatsApp" src="{{ asset('assets/img/whatsapp/WhatsAppButtonGreenLarge.png') }}" />
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-12">
                        <div class="pt-40 td-footer-bottom pb-15">
                            <div class="row align-items-center">
                                <div class="col-md-9">
                                    <div class="td-footer-bottom-copyright mb-30">
                                        <p>
                                            Copyright © <span id="current-year"></span> pacesetter.co.ke All rights reserved.
                                        </p>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="text-right td-footer-bottom-social mb-30">
                                        <span>
                                            <a href="https://www.instagram.com/pace_setter_mag/">
                                                <i class="fa-brands fa-instagram"></i>
                                            </a>
                                        </span>
                                        <span>
                                            <a href="https://x.com/the_pace_mag">
                                                <svg width="21" height="18" viewBox="0 0 21 18" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                    <path d="M16.3783 0.111328H19.3942L12.8054 7.64181L20.5565 17.8891H14.4875L9.73399 11.6742L4.2949 17.8891H1.27723L8.32453 9.83441L0.888855 0.111328H7.11199L11.4087 5.79201L16.3783 0.111328ZM15.3199 16.084H16.991L6.20396 1.82164H4.41068L15.3199 16.084Z" fill="currentColor"/>
                                                </svg>
                                            </a>
                                        </span>
                                        <span>
                                            <a href="https://wa.me/254726846918?text=Hello%20Pace%20Setter,%20I%20want%20to%20book%20an%20event">
                                                <i class="fa-brands fa-whatsapp"></i>
                                            </a>
                                        </span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </footer>
    <!-- footer-area-end -->

    <script src="{{ asset('assets/js/vendor/jquery.js') }}"></script>
    <script src="{{ asset('assets/js/bootstrap.min.js') }}"></script>
    <script src="{{ asset('assets/js/isotope.pkgd.min.js') }}"></script>
    <script src="{{ asset('assets/js/ion.rangeSlider.min.js') }}"></script>
    <script src="{{ asset('assets/js/imagesloaded.pkgd.min.js') }}"></script>
    <script src="{{ asset('assets/js/jquery.magnific-popup.min.js') }}"></script>
    <script src="{{ asset('assets/js/jquery.odometer.min.js') }}"></script>
    <script src="{{ asset('assets/js/jquery-appear.js') }}"></script>
    <script src="{{ asset('assets/js/swiper-bundle.min.js') }}"></script>
    <script src="{{ asset('assets/js/Jarallax.js') }}"></script>
    <script src="{{ asset('assets/js/nice-select.js') }}"></script>
    <script src="{{ asset('assets/js/ajax-form.js') }}"></script>
    <script src="{{ asset('assets/js/wow.min.js') }}"></script>
    <script src="{{ asset('assets/js/main.js') }}"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>

    <script>
      $(document).ready(function() {
        // Initialize Toastr
        toastr.options = {
          closeButton: true,
          progressBar: true,
          positionClass: "toast-top-right",
          timeOut: 5000,
          extendedTimeOut: 10000,
          preventDuplicates: true
        };

        // Updated Kenyan phone number validation function to match backend
        function isValidKenyanPhone(phone) {
          // Remove any non-digit characters except leading +
          let cleanedPhone = phone.replace(/[^0-9+]/g, '');
          
          // Remove leading + if present
          if (cleanedPhone.startsWith('+')) {
            cleanedPhone = cleanedPhone.substring(1);
          }

          // Check if it's a valid Kenyan phone number
          // Accepts: 0712345678, 0112345678, +254712345678, 254712345678, 712345678, 112345678
          if (cleanedPhone.startsWith('254') && cleanedPhone.length === 12) {
            return true;
          } else if (cleanedPhone.match(/^(07|01)\d{8}$/)) {
            return true;
          } else if (cleanedPhone.match(/^(7|1)\d{8}$/)) {
            return true;
          }
          return false;
        }

        // Clean phone number to match backend format (254XXXXXXXXX)
        function cleanPhoneNumber(phone) {
          let cleanedPhone = phone.replace(/[^0-9+]/g, '');
          
          // Remove leading + if present
          if (cleanedPhone.startsWith('+')) {
            cleanedPhone = cleanedPhone.substring(1);
          }

          // Convert to 254XXXXXXXXX format
          if (cleanedPhone.startsWith('254') && cleanedPhone.length === 12) {
            return cleanedPhone;
          } else if (cleanedPhone.match(/^(07|01)\d{8}$/)) {
            return '254' + cleanedPhone.substring(1);
          } else if (cleanedPhone.match(/^(7|1)\d{8}$/)) {
            return '254' + cleanedPhone;
          }
          return cleanedPhone; // Fallback to cleaned digits if format is unexpected
        }

        // Form submission handling
        $('#ticketForm').on('submit', function(e) {
          e.preventDefault();
          const form = $(this);
          const submitBtn = form.find('#submitBtn');
          
          // Clear previous error messages
          $('.text-danger').remove();
          
          // Client-side validation
          let isValid = true;
          const email = $('#recipient_email').val();
          let phone = $('#recipient_phone').val();
          const quantity = parseInt($('#quantity').val());

          // Email validation
          if (!email || !/^[^\s@]+@[^\s@]+\.[^\s@]+$/.test(email)) {
            $('#recipient_email').after('<span class="text-danger">Please enter a valid email address</span>');
            isValid = false;
          }

          // Phone validation - using the updated function
          if (!phone || !isValidKenyanPhone(phone)) {
            $('#recipient_phone').after('<span class="text-danger">Please enter a valid Kenyan phone number</span>');
            isValid = false;
          }

          // Quantity validation
          if (isNaN(quantity) || quantity < 1 || quantity > 20) {
            $('#quantity').after('<span class="text-danger">Please enter a valid number of tickets (1-20)</span>');
            isValid = false;
          }

          if (!isValid) {
            toastr.error('Please correct the errors in the form');
            return;
          }

          // Clean phone number before submission
          const cleanedPhone = cleanPhoneNumber(phone);
          $('#recipient_phone').val(cleanedPhone);

          // Show loading state
          form.addClass('form-loading');
          submitBtn.prop('disabled', true);
          submitBtn.find('.submit-text').addClass('d-none');
          submitBtn.find('.spinner-border').removeClass('d-none');

          // Submit form via AJAX
          $.ajax({
            url: form.attr('action'),
            method: 'POST',
            data: form.serialize(),
            success: function(response) {
              // Handle success
              toastr.success('Ticket generated and notifications sent successfully!');
              form.removeClass('form-loading');
              submitBtn.prop('disabled', false);
              submitBtn.find('.submit-text').removeClass('d-none');
              submitBtn.find('.spinner-border').addClass('d-none');
              form[0].reset();
            },
            error: function(xhr) {
              form.removeClass('form-loading');
              submitBtn.prop('disabled', false);
              submitBtn.find('.submit-text').removeClass('d-none');
              submitBtn.find('.spinner-border').addClass('d-none');
              
              // Handle errors
              if (xhr.status === 422) {
                const errors = xhr.responseJSON.errors;
                $.each(errors, function(field, messages) {
                  $(`#${field}`).after(`<span class="text-danger">${messages[0]}</span>`);
                });
                toastr.error('Please correct the errors in the form');
              } else {
                toastr.error('An error occurred while generating the ticket');
              }
            }
          });
        });

        // Phone number formatting for display
        $('#recipient_phone').on('input', function() {
          let phone = $(this).val().replace(/\D/g, '');
          
          // Format based on input
          if (phone.startsWith('254')) {
            // Already in international format without +
            if (phone.length > 3) {
              phone = phone.substring(0, 3) + ' ' + phone.substring(3);
            }
            if (phone.length > 7) {
              phone = phone.substring(0, 7) + ' ' + phone.substring(7);
            }
          } else if (phone.startsWith('0')) {
            // Local format
            if (phone.length > 1) {
              phone = phone.substring(0, 1) + ' ' + phone.substring(1);
            }
            if (phone.length > 5) {
              phone = phone.substring(0, 5) + ' ' + phone.substring(5);
            }
          }
          
          $(this).val(phone);
        });
      });
    </script>
  </body>
</html>