<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>Admin Login - OTP Authentication</title>
    
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    
    <style>
        :root {
            --primary-color: rgb(77, 11, 139);
            --secondary-color: rgb(117, 13, 143);
            --light-color: #f8f9fa;
            --dark-color: #212529;
            --gray-color: #bebcbe;
        }
        
        body {
            background-color: #f5f5f5;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            min-height: 100vh;
            display: flex;
            align-items: center;
        }
        
        .login-container {
            max-width: 1200px;
            margin: 0 auto;
            border-radius: 15px;
            overflow: hidden;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.1);
            background-color: white;
        }
        
        .login-card {
            border: none;
            border-radius: 10px;
        }
        
        .login-header {
            background: linear-gradient(135deg, var(--primary-color), var(--secondary-color));
            color: white;
            padding: 1.5rem;
            text-align: center;
        }
        
        .login-title {
            font-weight: 700;
            letter-spacing: 1px;
            margin-bottom: 0;
        }
        
        .form-label {
            font-weight: 600;
            color: var(--primary-color);
            margin-bottom: 0.5rem;
        }
        
        .btn-primary-custom {
            background-color: var(--secondary-color);
            border: none;
            padding: 12px;
            font-weight: 600;
            transition: all 0.3s ease;
            width: 100%;
        }
        
        .btn-primary-custom:hover {
            background-color: var(--primary-color);
            transform: translateY(-2px);
        }
        
        .btn-outline-primary-custom {
            color: var(--secondary-color);
            border-color: var(--secondary-color);
            font-weight: 600;
            padding: 10px 15px;
        }
        
        .btn-outline-primary-custom:hover {
            background-color: var(--secondary-color);
            color: white;
        }
        
        .input-group-text {
            background-color: white;
            border-right: none;
        }
        
        .form-control {
            border-left: none;
        }
        
        .login-footer {
            text-align: center;
            margin-top: 1.5rem;
            font-size: 0.9rem;
        }
        
        .login-footer a {
            color: var(--primary-color);
            text-decoration: none;
            font-weight: 500;
            transition: all 0.2s ease;
        }
        
        .login-footer a:hover {
            color: var(--secondary-color);
            text-decoration: underline;
        }
        
        .logo-container {
            display: flex;
            justify-content: center;
            align-items: center;
            height: 100%;
            padding: 2rem;
            background-color: rgba(255, 255, 255, 0.9);
        }
        
        .logo-img {
            max-width: 100%;
            height: auto;
            transition: transform 0.3s ease;
        }
        
        .logo-img:hover {
            transform: scale(1.05);
        }
        
        /* Animation for OTP input */
        @keyframes pulse {
            0% { transform: scale(1); }
            50% { transform: scale(1.02); }
            100% { transform: scale(1); }
        }
        
        .otp-input {
            animation: pulse 2s infinite;
            letter-spacing: 5px;
            font-size: 1.2rem;
            text-align: center;
            padding: 10px;
        }
        
        /* Responsive adjustments */
        @media (max-width: 992px) {
            .logo-container {
                padding: 1.5rem;
            }
            .login-container {
                margin: 1rem;
            }
        }
        
        @media (max-width: 768px) {
            .login-container {
                margin: 0.5rem;
                border-radius: 10px;
            }
            .logo-container {
                padding: 1rem;
            }
            .login-header {
                padding: 1rem;
            }
            .login-title {
                font-size: 1.5rem;
            }
        }
        
        /* Notification styling */
        .notification-container {
            position: fixed;
            top: 20px;
            right: 20px;
            z-index: 9999;
            width: 100%;
            max-width: 350px;
        }
        
        .alert {
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
            border: none;
        }
        
        /* Form input styling */
        .form-section {
            padding: 2rem;
        }
        
        .input-field {
            margin-bottom: 1.5rem;
        }
        
        .action-buttons {
            margin-top: 2rem;
        }
        
        /* Phone input container */
        .phone-input-container {
            display: flex;
            gap: 10px;
        }
        
        .phone-input {
            flex: 1;
        }
        
        @media (max-width: 576px) {
            .phone-input-container {
                flex-direction: column;
            }
        }
    </style>
</head>
<body>
    <!-- Notification Container -->
    <div class="notification-container"></div>
    
    <div class="login-container">
        <div class="row g-0">
            <!-- Logo Section -->
            <div class="col-lg-5 d-flex align-items-center">
                <div class="logo-container">
                    <img src="{{ asset('assets/img/logo/logo.png') }}" alt="Company Logo" class="logo-img">
                </div>
            </div>
            
            <!-- Form Section -->
            <div class="col-lg-7">
                <div class="login-card h-100">
                    <div class="login-header">
                        <h2 class="login-title">ADMIN LOGIN</h2>
                    </div>
                    
                    <div class="form-section">
                        <!-- Session Status -->
                        @if (session('status'))
                            <div class="mb-4 alert alert-success bg-success">
                                {{ session('status') }}
                            </div>
                        @endif
                        
                        <!-- Validation Errors -->
                        @if ($errors->any())
                            <div class="mb-4 alert alert-danger">
                                <ul class="mb-0">
                                    @foreach ($errors->all() as $error)
                                        <li>{{ $error }}</li>
                                    @endforeach
                                </ul>
                            </div>
                        @endif
                        
                        <form method="POST" action="{{ route('login.otp') }}" id="loginForm">
                            @csrf
                            
                            <!-- Phone Number Input -->
                            <div class="input-field">
                                <label for="phone" class="form-label">
                                    <i class="fas fa-mobile-alt me-2"></i> PHONE NUMBER
                                </label>
                                <div class="phone-input-container">
                                    <div class="input-group phone-input">
                                        <span class="input-group-text">
                                            <i class="fas fa-phone"></i>
                                        </span>
                                        <input 
                                            type="tel" 
                                            id="phone" 
                                            name="phone" 
                                            class="form-control form-control-lg col-lg-4 col-sm-12" 
                                            placeholder="e.g. 0712345678" 
                                            required 
                                            autofocus
                                            pattern="[0-9]{9,12}"
                                            title="Enter a valid phone number (9-12 digits)"
                                        >
                                    </div>
                                    <button 
                                        type="button" 
                                        id="sendOtpBtn" 
                                        class="btn btn-outline-primary-custom"
                                    >
                                        <i class="fas fa-paper-plane me-2"></i> Send OTP
                                    </button>
                                </div>
                                <small class="text-muted">We'll send a 6-digit verification code</small>
                            </div>
                            
                            <!-- OTP Input -->
                            <div class="input-field">
                                <label for="otp" class="form-label">
                                    <i class="fas fa-key me-2"></i> OTP CODE
                                </label>
                                <input 
                                    type="text" 
                                    id="otp" 
                                    name="otp" 
                                    class="form-control form-control-lg otp-input" 
                                    placeholder="Enter 6-digit code" 
                                    required
                                    pattern="[0-9]{6}"
                                    title="Enter the 6-digit OTP"
                                    maxlength="6"
                                >
                            </div>
                            
                            <!-- Submit Button -->
                            <div class="action-buttons">
                                <button type="submit" class="btn btn-primary-custom btn-lg">
                                    <i class="fas fa-sign-in-alt me-2"></i> LOGIN
                                </button>
                            </div>
                            
                            <!-- Footer Links -->
                            <div class="login-footer">
                                {{-- <p class="mb-2">Don't have an account? 
                                    <a href="{{ route('register') }}">
                                        <i class="fas fa-user-plus me-1"></i> Register here
                                    </a>
                                </p> --}}
                                <p class="mb-0">
                                    <a href="#">
                                        <i class="fas fa-question-circle me-1"></i> Need help?
                                    </a>
                                </p>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Bootstrap Bundle with Popper -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    
    <!-- Custom JavaScript -->
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const sendOtpBtn = document.getElementById('sendOtpBtn');
            const phoneInput = document.getElementById('phone');
            const otpInput = document.getElementById('otp');
            const loginForm = document.getElementById('loginForm');
            const notificationContainer = document.querySelector('.notification-container');

            // Function to show notification
            function showNotification(message, type = 'success') {
                const notification = document.createElement('div');
                notification.className = `alert alert-${type} alert-dismissible fade show`;
                notification.role = 'alert';
                notification.innerHTML = `
                    ${message}
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                `;
                
                notificationContainer.appendChild(notification);
                
                // Auto remove after 5 seconds
                setTimeout(() => {
                    notification.classList.remove('show');
                    setTimeout(() => notification.remove(), 150);
                }, 5000);
            }

            // Handle OTP sending
            sendOtpBtn.addEventListener('click', async function() {
                const phone = phoneInput.value.trim();
                
                if (!phone || phone.length < 9) {
                    showNotification('Please enter a valid phone number (at least 9 digits)', 'danger');
                    return;
                }

                sendOtpBtn.disabled = true;
                const originalText = sendOtpBtn.innerHTML;
                sendOtpBtn.innerHTML = '<span class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span> Sending...';

                try {
                    const response = await fetch("{{ route('login.otp.generate') }}", {
                        method: 'POST',
                        headers: {
                            'Content-Type': 'application/json',
                            'X-CSRF-TOKEN': '{{ csrf_token() }}',
                            'Accept': 'application/json'
                        },
                        body: JSON.stringify({ phone: phone })
                    });

                    const data = await response.json();

                    if (!response.ok) {
                        // Check for unregistered phone error (401 status)
                        if (response.status === 401 && data.error) {
                            throw new Error(data.error);
                        }
                        throw new Error(data.error || 'Failed to send OTP. Please try again.');
                    }

                    showNotification('OTP sent successfully! Check your phone.');
                    otpInput.focus();
                } catch (error) {
                    console.error('OTP Error:', error);
                    showNotification(error.message, 'danger');
                } finally {
                    sendOtpBtn.disabled = false;
                    sendOtpBtn.innerHTML = originalText;
                }
            });

            // Format phone input (allow only digits)
            phoneInput.addEventListener('input', function(e) {
                e.target.value = e.target.value.replace(/\D/g, '');
            });

            // Handle form submission
            loginForm.addEventListener('submit', function(e) {
                const otp = otpInput.value.trim();
                
                if (!otp || otp.length !== 6) {
                    e.preventDefault();
                    showNotification('Please enter a valid 6-digit OTP code', 'danger');
                    otpInput.focus();
                }
            });
        });
    </script>
</body>
</html>