#!/bin/bash

echo "=== STK Status Monitor ==="
echo ""

echo "📊 Current STK Transaction Status:"
php artisan tinker --execute="
\$stats = App\Models\TxnLog::selectRaw('stk_status, COUNT(*) as count')
    ->groupBy('stk_status')
    ->get();
foreach(\$stats as \$stat) {
    echo \$stat->stk_status . ': ' . \$stat->count . PHP_EOL;
}
"

echo ""
echo "🔄 Recent Status Updates (Last 10):"
php artisan tinker --execute="
\$logs = App\Models\Log::where('source', 'STK Status Update')
    ->latest()
    ->take(10)
    ->get();
foreach(\$logs as \$log) {
    \$data = json_decode(\$log->content, true);
    echo '[' . \$log->created_at->format('Y-m-d H:i:s') . '] ';
    echo 'ID: ' . (\$data['checkout_request_id'] ?? 'N/A') . ' ';
    echo 'Status: ' . (\$data['old_status'] ?? 'N/A') . ' → ' . (\$data['new_status'] ?? 'N/A') . PHP_EOL;
}
"

echo ""
echo "⏰ Next Scheduled Run:"
php artisan schedule:list

echo ""
echo "📝 Recent Laravel Logs (Last 5 lines):"
tail -n 5 storage/logs/laravel.log 2>/dev/null || echo "No log file found"

echo ""
echo "🔍 Manual Test Commands:"
echo "  php artisan stk:check-status --limit=5"
echo "  php artisan schedule:run"
echo "  php artisan schedule:list" 