<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;

class ScannerRoleSeeder extends Seeder
{
    public function run()
    {
        // Reset cached roles and permissions
        app()[\Spatie\Permission\PermissionRegistrar::class]->forgetCachedPermissions();

        // Create scanner-specific permissions
        $scannerPermissions = [
            'scan-tickets',
            'validate-tickets', 
            'view-scan-history',
            'generate-scan-reports'
        ];

        foreach ($scannerPermissions as $permission) {
            Permission::firstOrCreate(['name' => $permission]);
        }

        // Create scanner role and assign permissions
        $scanner = Role::firstOrCreate(['name' => 'scanner']);
        $scanner->givePermissionTo($scannerPermissions);

        $this->command->info('Scanner role and permissions created successfully!');
    }
}