<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\MessageTemplate;

class MessageTemplateSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $templates = [
            [
                'name' => 'Welcome Message',
                'description' => 'Welcome new contacts',
                'content' => 'Welcome {first-name}! Thank you for joining us. Visit https://events.pacesetter.co.ke/ for more info.',
                'is_active' => true,
            ],
            [
                'name' => 'Early Bird Promo',
                'description' => 'Early bird promotion',
                'content' => 'Hi {first-name}! Early bird tickets for TeenzFest 2025 are now available for KSH 500. Get yours at https://events.pacesetter.co.ke/',
                'is_active' => true,
            ],
            [
                'name' => 'Event Reminder',
                'description' => 'General event reminder',
                'content' => 'Dear {first-name}, don\'t forget TeenzFest 2025 on 29th NOV! Your school {school} is invited. Get tickets: https://events.pacesetter.co.ke/',
                'is_active' => true,
            ],
            [
                'name' => 'Ticket Confirmation',
                'description' => 'Ticket purchase confirmation',
                'content' => 'Hi {first-name}! Your {ticket-type} ticket for {event-name} on {event-date} has been confirmed. See you there!',
                'is_active' => true,
            ],
            [
                'name' => 'Event Update',
                'description' => 'Important event updates',
                'content' => 'Hello {name}, we have an important update about {event-name}. Please check your email or visit our website for details.',
                'is_active' => true,
            ],
        ];

        foreach ($templates as $template) {
            MessageTemplate::create($template);
        }
    }
}