<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;
use App\Models\User;

class GrantAdminRightsSeeder extends Seeder
{
    public function run(): void
    {
        $email = 'admin@example.com';

        $permissions = [
            'view-users',
            'edit-users',
            'delete-users',
            'view-tickets',
            'view-metrics',
            'access-messages',
            'access-complimentary',
            'manage-contacts',
        ];

        foreach ($permissions as $perm) {
            Permission::firstOrCreate(['name' => $perm, 'guard_name' => 'web']);
        }

        $role = Role::firstOrCreate(['name' => 'super-admin', 'guard_name' => 'web']);
        $role->syncPermissions($permissions);

        $user = User::where('email', $email)->first();

        if (!$user) {
            $this->command->error("User with email {$email} not found.");
            return;
        }

        $user->assignRole($role->name);
        $user->syncPermissions($permissions);

        $this->command->info("Granted super-admin role and all permissions to {$email}.");
    }
}
