<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;

class EventSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $eventName = 'TeenzFest 2025';
        
        DB::table('events')->insert([
            [
                'id' => 1,
                'name' => $eventName,
                'slug' => Str::slug($eventName),
                'venue' => 'KICC Grounds',
                'date' => '2025-11-30',
                'tickets' => json_encode([
                    'early_bird' => 500,      // Individual early bird (existing)
                    'advance' => 800,         // Individual advance (existing)
                    'gate' => 1000,           // Individual gate price (existing)
                    'group_4' => 1500,        // NEW: Group of 4
                    'group_5' => 2000,        // NEW: Group of 5
                    'group_10' => 4000,       // NEW: Group of 10
                ]),
                'event_image' => 'uploads/events/1744413862_nibenip_by_slnbnsintention_dhkpwtc.jpg',
                'intro_video' => 'https://youtu.be/fxHISPvGiRI',
                'created_at' => '2025-04-11 20:24:22',
                'updated_at' => '2025-04-11 20:24:22',
            ],
        ]);
    }
}