<?php

namespace Database\Seeders;

use App\Models\User;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Hash;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;

class AdminUserSeeder extends Seeder
{
    public function run()
    {
        // Create or find the super-admin user
        $admin = User::firstOrCreate(
            ['phone' => '254757909044'],
            [
                'name' => 'Admin User',
                'email' => 'admin@example.com',
                'password' => Hash::make('secure_password'),
            ]
        );

        // Ensure the super-admin role exists and assign it
        $superAdminRole = Role::where('name', 'super-admin')->first();
        if ($superAdminRole) {
            $admin->assignRole($superAdminRole);
        }

        // Create or find the management user
        $managementUser = User::firstOrCreate(
            ['phone' => '254769394191'],
            [
                'name' => 'Management User',
                'email' => 'management@example.com',
                'password' => Hash::make('secure_password'),
            ]
        );

        // Ensure the management role exists and assign it
        $managementRole = Role::where('name', 'management')->first();
        if ($managementRole) {
            $managementUser->assignRole($managementRole);
        }

        // Create a customer support user for testing
        $customerSupportUser = User::firstOrCreate(
            ['phone' => '254700000000'],
            [
                'name' => 'Customer Support User',
                'email' => 'support@example.com',
                'password' => Hash::make('secure_password'),
            ]
        );

        // Ensure the customer-support role exists and assign it
        $customerSupportRole = Role::where('name', 'customer-support')->first();
        if ($customerSupportRole) {
            $customerSupportUser->assignRole($customerSupportRole);
        }
    }
}