<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;

class AddAdminRoleSeeder extends Seeder
{
    public function run()
    {
        // Reset cached roles and permissions
        app()[\Spatie\Permission\PermissionRegistrar::class]->forgetCachedPermissions();

        // Ensure all permissions exist
        $permissions = [
            'view-users',
            'create-users', 
            'edit-users',
            'delete-users',
            'access-messages',
            'manage-contacts', 
            'view-tickets',
            'view-metrics',
            'access-complimentary'
        ];

        foreach ($permissions as $permission) {
            Permission::firstOrCreate(['name' => $permission]);
        }

        // Create the new admin role
        $adminRole = Role::firstOrCreate(['name' => 'admin']);
        
        // Assign permissions to admin role (all except delete-users)
        $adminPermissions = [
            'view-users',
            'create-users', 
            'edit-users',
            'access-messages',
            'manage-contacts', 
            'view-tickets',
            'view-metrics',
            'access-complimentary'
        ];
        
        $adminRole->syncPermissions($adminPermissions);

        $this->command->info('Admin role created successfully with permissions:');
        $this->command->info(implode(', ', $adminPermissions));
        $this->command->info('Note: Admin role does NOT have delete-users permission');
    }
}