<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('complimentary_codes', function (Blueprint $table) {
            $table->string('email_status')->default('pending')->after('sms_error');
            $table->string('email_error')->nullable()->after('email_status');
            $table->index('email_status');
        });
    }

    public function down(): void
    {
        Schema::table('complimentary_codes', function (Blueprint $table) {
            $table->dropIndex(['email_status']);
            $table->dropColumn(['email_status', 'email_error']);
        });
    }
};