<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('txn_logs', function (Blueprint $table) {
            // STK-specific fields
            $table->id();
            $table->string('transaction_type')->default('stk');
            $table->string('trans_id')->default(uniqid());
            $table->timestamp('trans_time')->default(now());
            $table->decimal('trans_amount', 10, 2)->default(0);
            $table->string('ticket_reference_number')->nullable();
            $table->text('stk_request')->nullable();
            $table->text('stk_response')->nullable();
            $table->decimal('amount', 10, 2)->nullable();
            $table->timestamp('transaction_date')->nullable();
            $table->enum('stk_status', ['Launched', 'Failed', 'Canceled', 'Timeout', 'Success','Invalid-user-input','insufficient-funds','User-cannot-be-reached','No-response-from-user'])->default('Launched');
            $table->string('checkout_request_id')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('txn_logs');
    }
};
