<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class TxnLog extends Model
{
    use HasFactory;

    protected $table = 'txn_logs';

    protected $fillable = [
        'transaction_type',
        'trans_id',
        'trans_time',
        'trans_amount',
        'ticket_reference_number',
        'stk_request',
        'stk_response',
        'amount',
        'transaction_date',
        'stk_status',
        'checkout_request_id',
        'telco',
    ];

    protected $casts = [
        'transaction_date' => 'datetime',
        'trans_amount' => 'decimal:2',
        'amount' => 'decimal:2',
    ];
}
