<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Builder;

class ComplimentaryCode extends Model
{
    protected $fillable = [
        'code',
        'event_id',
        'generated_by_name',
        'is_used',
        'used_at',
        'used_by_name',
        'expires_at',
        'notes',
        'recipient_name',
        'recipient_phone',
        'recipient_email',
        'sms_status',
        'sms_error',
        'email_status',
        'email_error',
        'sent_to',
        'ticket_quantity',
        'ticket_type',
        'redeemed_count'
    ];

    protected $casts = [
        'expires_at' => 'datetime',
        'used_at' => 'datetime',
        'sent_at' => 'datetime',
        'is_used' => 'boolean',
        'ticket_quantity' => 'integer',
        'redeemed_count' => 'integer',
    ];

    // Relationships
    public function event()
    {
        return $this->belongsTo(Event::class);
    }

    public function ticket()
    {
        return $this->hasOne(Ticket::class, 'complimentary_code', 'code');
    }

    // Scopes
    public function scopeActive(Builder $query)
    {
        return $query->where('is_used', false)
            ->where('expires_at', '>', now());
    }

    public function scopeExpired(Builder $query)
    {
        return $query->where('expires_at', '<', now());
    }

    public function scopeUsed(Builder $query)
    {
        return $query->where('is_used', true);
    }
}