<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class RestrictScannerRole
{
    public function handle(Request $request, Closure $next)
    {
        if (Auth::check() && Auth::user()->hasRole('scanner')) {
            $allowedRoutes = ['users.scanner', 'logout']; // add more if needed
            $currentRouteName = $request->route()->getName();

            if (!in_array($currentRouteName, $allowedRoutes) && !$request->is('login')) {
                return redirect()->route('users.scanner')
                    ->with('error', 'Access denied. You are restricted to the scanner page only.');
            }
        }

        return $next($request);
    }
}