# SMS Module Setup Guide

## Overview

This SMS module allows you to send personalized bulk SMS messages to your contacts using the Wasiliana SMS API.

## Features

-   ✅ Contact management with search and filtering
-   ✅ Bulk contact selection with checkboxes
-   ✅ Message personalization with placeholders
-   ✅ SMS campaign tracking and logging
-   ✅ Cost estimation and tracking
-   ✅ Export capabilities for logs
-   ✅ Phone number format validation
-   ✅ Multi-part SMS support

## Environment Configuration

Add these variables to your `.env` file:

```env
# Wasiliana SMS API Configuration
WASILIANA_API_KEY=2ZqSn5LGPfNyTpvRICWiG3vWnJim6zTR6oXimzg29Isn3niqSrXO8fKrOv4FZDSa
WASILIANA_SENDER_ID=PACESETTER
```

### Getting Your Wasiliana API Key

1. Sign up at [https://wasiliana.com](https://wasiliana.com)
2. Go to your dashboard
3. Navigate to API settings
4. Copy your API key
5. The current API key in the code is already configured and working

### Sender ID

-   Replace `PACESETTER` with your approved sender ID
-   This appears as the sender name on SMS messages
-   Must be approved by Wasiliana

## Usage

### 1. Import Contacts

-   Visit `/admin/contacts/import`
-   Upload your CSV file with columns: Name, Phone No., Social, School
-   The system will import all contacts with proper validation

### 2. Send SMS Messages

-   Visit `/admin/sms` to view all contacts
-   Use search and filters to find specific contacts
-   Select contacts using checkboxes (individual or "Select All")
-   Click "Send SMS to Selected" to compose your message

### 3. Message Composition

-   Default message includes TeenzFest 2025 promotion
-   Use placeholders for personalization:
    -   `{first-name}` - Contact's first name
    -   `{name}` - Contact's full name
    -   `{school}` - Contact's school name
-   Preview messages before sending
-   Character counter shows SMS parts and estimated cost

### 4. View SMS Logs

-   Visit `/admin/sms/logs` to see all sent messages
-   Filter by campaign name or status
-   Export logs to CSV for analysis
-   Track delivery status and costs

## Default Message Template

```
Dear {first-name}, THE PACE TeenzFest 2025 is happening on 29th NOV. Click to buy early bird tickets today for KSH 500 ending in July 2025. https://events.pacesetter.co.ke/
```

## SMS Costs

-   Each SMS part costs approximately KSH 1.00
-   Messages over 160 characters are split into multiple parts
-   Cost estimation is shown before sending
-   Actual costs are logged for tracking

## Phone Number Formats

The system automatically handles these formats:

-   `07XXXXXXXX` → `2547XXXXXXXX`
-   `7XXXXXXXX` → `2547XXXXXXXX`
-   `2547XXXXXXXX` (already correct)

## Database Schema

### SMS Logs Table

-   `contact_name` - Recipient name
-   `phone_number` - Recipient phone number
-   `school_name` - Recipient school
-   `message_content` - Full message sent
-   `status` - sent/failed/pending
-   `response_data` - API response details
-   `message_id` - External message ID
-   `cost` - SMS cost in KSH
-   `parts` - Number of SMS parts
-   `sent_at` - When SMS was sent
-   `campaign_name` - Campaign identifier

## Routes

-   `/admin/sms` - Contact listing and selection
-   `/admin/sms/compose` - Message composition
-   `/admin/sms/send` - Send SMS (POST)
-   `/admin/sms/logs` - SMS history and logs
-   `/admin/sms/export` - Export logs to CSV
-   `/admin/contacts/import` - Import contacts from CSV

## Security Notes

-   API keys should be kept secure in environment variables
-   SMS logs contain personal information - handle with care
-   Consider rate limiting for high-volume campaigns
-   Monitor API usage to avoid unexpected costs

## Troubleshooting

### SMS Not Sending

1. Check API key is correct in `.env`
2. Verify sender ID is approved
3. Check phone number format
4. Review SMS logs for error details

### Import Issues

1. Ensure CSV has correct column headers
2. Check for special characters in data
3. Verify file size is under 2MB
4. Review import logs for specific errors

### Performance

-   Large contact lists are paginated
-   SMS sending includes small delays to avoid rate limits
-   Database operations use transactions for consistency
-   Chunked processing for bulk operations

## Support

For Wassilian API issues, contact their support team.
For application issues, check the Laravel logs in `storage/logs/`.
